!+
!KWIC vfocus.f
!
!$Id: vfocus.f,v 1.2 2004/03/17 21:23:44 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-
!
!  UPDATED 5/9/88 TO SIMPLIFY CALCULATIONS TO FIGHT NUMERICAL ROUNDOFF
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE VFOCUS (K, L, W, AR)
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    VFOCUS FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 05/21/80
C    *
C    *    UPDATE:   07/01/80
C    *    TIME:     10:35:02
C    *
C    ******************************************/
C
C  FOCUS A BUNDLE OF RAYS USING A LEAST SQUARE METHOD
C  GIVEN A COLLECTION OF LINES IN SPACE, VFOCUS WILL FIND THAT POINT
C  WHICH MINIMIZES THE SUM SQUARE PERPENDICULAR DISTANCE TO THE LINES
C
C  INPUT ARGUMENTS:
C  K     : IV# OF ANY POINT ON THE LINE OR RAY
C  L     : IV# OF DIRECTION COSINES OF LINE OR RAY
C  W     : R*4 RELATIVE WEIGHT OR INTENSITY OF RAY
C  AR    : R*8 ARRAY OF QUADRATIC COEFFICIENTS TO BE UPDATED
C
C  OUTPUT ARGUMENT: AR = (UPDATED) COEFFICIENTS ARRAY
C
C  INPUT VIA /XCOMP/, /YCOMP/, AND /ZCOMP/:
C  THE VECTORS IN LOCATIONS K AND L
!
!  OUTPUT VIA /XCOMP/, /YCOMP/, /ZCOMP/:
!  THE VECTOR IN LOCATION 41 IS USED AS SCRATCH
C
C  USAGE : SET AR= 0 BEFORE CALLING VFOCUS FOR THE FIRST RAY.
C    FOR EACH RAY CALL VFOCUS AS ABOVE TO UPDATE AR.
C    THEN AR WILL COMPRISE :
C    AR(1-6)   :   POSITIVE DEFINITE MATRIX IN SYMMETRIC MODE
C    AR(7-9)   :   COLUMN VECTOR X
C    AR(10 )   :   CONSTANT C
C
C    THEN FIND Q = INVERSE OF P AND
C     F = Q * X , WHERE F IS THE FOCUS
C     PHI = C - X TRANSPOSE * F
C    THE RMS SPOT SIZE = SORT (PHI / NRAY) , WHERE NRAY = # RAYS
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      DOUBLE PRECISION AR (10), BR (10)

      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

C
C  DEFINE BR = ARRAY OF UPDATE VALUES
C
      BR( 1) =  1.0D0 - XV(L) ** 2
      BR( 2) = -XV(L) * YV(L)
      BR( 3) =  1.0D0 - YV(L) ** 2
      BR( 4) = -XV(L) * ZV(L)
      BR( 5) = -YV(L) * ZV(L)
      BR( 6) =  1.0D0 - ZV(L) ** 2
!
!  REDEFINE 7-10 TO SIMPLIFY AND IMPROVE ROUNDOFF ERROR
!     BR( 7) = XV(K) * BR(1) + YV(K) * BR(2) + ZV(K) * BR(4)
!     BR( 8) = XV(K) * BR(2) + YV(K) * BR(3) + ZV(K) * BR(5)
!     BR( 9) = XV(K) * BR(4) + YV(K) * BR(5) + ZV(K) * BR(6)
!     BR(10) = XV(K) * BR(7) + YV(K) * BR(8) + ZV(K) * BR(9)
!
      PDOTS  = VDOT (K, L)
      CALL VCROSS (K, L, 41)
      BR( 7) = XV (K) - XV (L) * PDOTS
      BR( 8) = YV (K) - YV (L) * PDOTS
      BR( 9) = ZV (K) - ZV (L) * PDOTS
      BR(10) = VDOT (41, 41)
!
C
C  UPDATE AR
      DO 10 I = 1, 10
      AR (I) = AR (I) + W * BR (I)
10    CONTINUE
      RETURN
      END
