!+
!KWIC vfold.f
!
!$Id: vfold.f,v 1.2 2004/03/17 21:23:44 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!      . change to IMPLICIT NONE
!-
      SUBROUTINE VFOLD (KP, LP, LFO, NFO, KX, LX)
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    VFOLD FORTRAN
C    *    WRITTEN BY JOHN LEGG
C    *            ON 10/29/80
C    *
C    *    UPDATE:   11/03/80
C    *    TIME:     15:28:20
C    *
C    ******************************************/
C
C  FOLD A RAY ABOUT A PLANE
C
C  INPUT ARGUMENTS:
C    KP  : I*4 - IV# OF POSITION OF INPUT RAY
C    LP  : I*4 - IV# OF DIRECTION OF INPUT RAY
C    LFO : I*4 - IV# OF FOLD ORIGIN WRT BCS
C    NFO : I*4 - IV# OF UNIT FOLD NORMAL WRT BCS
C    KX  : I*4 - IV# DESIRED FOR POSITION OF FOLDED RAY
C    LX  : I*4 - IV# DESIRED FOR DIRECTION OF FOLDED RAY
C
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/:
C    VECTORS WHOSE INDEX #S ARE KP, LP, LFO, NFO
C
C  OUTPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/:
C    VECTORS WHOSE INDEX #S ARE KX, LX
C
C  EXTERNAL REFERENCES: NONE
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT NONE

      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      INTEGER          KP, LP, LFO, NFO, KX, LX
      DOUBLE PRECISION X, Y, Z, DP

C  TRANSLATE VECTOR TO FOLD ORIGIN
      X = XV (KP) - XV (LFO)
      Y = YV (KP) - YV (LFO)
      Z = ZV (KP) - ZV (LFO)
C
C  TAKE DOT PRODUCT WITH NORMAL
      DP = X * XV (NFO) + Y * YV (NFO) + Z * ZV (NFO)
      DP = DP + DP
C
C  CALCULATE FOLDED VECTOR
      XV (KX) = X - DP * XV (NFO) + XV (LFO)
      YV (KX) = Y - DP * YV (NFO) + YV (LFO)
      ZV (KX) = Z - DP * ZV (NFO) + ZV (LFO)
C
C  CALCULATE FOLDED VECTOR DIRECTION
      DP = XV (LP) * XV (NFO) + YV (LP) * YV (NFO) + ZV (LP) * ZV (NFO)
      DP = DP + DP
C
      XV (LX) = XV (LP) - DP * XV (NFO)
      YV (LX) = YV (LP) - DP * YV (NFO)
      ZV (LX) = ZV (LP) - DP * ZV (NFO)
C
      RETURN
      END
