!+
!KWIC vinit.f
!
!$Id: vinit.f,v 1.2 2004/03/17 21:23:44 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /COMIC/:  add save statement; move to include file
!      . /RAIN/:   add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!      . initialize RAD as parameter
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 5/17/89 TO INCLUDE TOROID-RELATED INITIALIZATION
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!        !  UPDATED 4/1/91 TO CHANGE THE X-RAY FLAG FROM A SYSTEM FLAG
!        !  TO A SURFACE FLAG, SO THAT X-RAY AND CONVENTIONAL SURFACES
!        !  CAN BE COMBINED
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!      . eliminate X, Y, Z, Q1 - not used
!-
!
!  UPDATED 1/22/88 TO INCLUDE OBSCURATION-RELATED INITIALIZATION
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 5/9/88 TO ALLOW FOR FINITE DISTANCE POINT SOURCE
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE VINIT
C   /******************************************/
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    VINIT FORTRAN
C    *    WRITTEN BY
C    *            ON 08/28/80
C    *
C    *    UPDATE:   01/06/82
C    *    TIME:     12:54:35
C    *
C    ******************************************/
C
C  INITIALIZE THE VECTOR AND VECTOR-RELATED QUANTITIES
C
C  INPUT VIA LABELED COMMON /PARM/:
C    GEN(7):  R*8 - AZBU - AZIMUTH ANGLE OF INCOMING BUNDLE (DEG.)
C    GEN(8):  R*8 - ELBU - ELEVATION ANGLE OF INCOMING BUNDLE (DEG.)
C
C    IF SURFACE NUMBER = J, THEN,
C    SURF(1,J) :  R*8 - X - X COORD. AT SURFACE CENTER
C    SURF(2,J) :  R*8 - Y - Y COORD. AT SURFACE CENTER
C    SURF(3,J) :  R*8 - Z - Z COORD. AT SURFACE CENTER
C    SURF(4,J) :  R*8 - AZF - AZIMUTH OF NORMAL TO FOLD PLANE OR
!                       DIM1 - INNER RADIUS OR X-WIDTH OF OBSC
C    SURF(5,J) :  R*8 - ELF - ELEVATION OF NORMAL TO FOLD PLANE OR
!                       DIM2 - OUTER RADIUS OR Y-WIDTH OF OBSC
C    SURF(6,J) :  R*8 - ZFOLD - Z COORD. OF INTERSECTION OF STD
C                       Z AXIS WITH FOLD PLANE OR
!                       ZROT8 - ANGLE ABOUT Z FOR RECT OBSC, OR
!                       RTOR - TOROIDAL RADIUS
C    SURF(7,J) :  R*8 - AZMIS - AZIMUTH MISALIGNMENT OF SURFACE
C                       (DEG.)
C    SURF(8,J) :  R*8 - ELMIS - ELEVATION MISALIGNMENT OF SURFACE
C                       (DEG.)
C    SURF(9,J) :  R*8 - BORESIGHT ANGLE OF OFFSET SURFACE
C    SURF(10,J):  R*8 - OUTER RADIUS OF CONV. OR LENGTH OF X-RAY
C                        SURFACE
C    SURF(11,J) : R*8 - ANGLE ABOUT Z FOR TOROIDAL SURFACE
C
C  INPUT VIA LABELED COMMON /PARX/:
C    KURF : I*4 - SURFACE NUMBER
C
C  INPUT VIA LABELED COMMON /SWITCH/:
C    GENERAL SYSTEM SWITCH:
C    SWITCHES FOR SURFACE J:
C    LSW(3,J) :  L*1 - F: NOT FLAT, T : FLAT
C    LSW(4,J) :  L*1 - F: ON AXIS, T : OFF AXIS
C    LSW (3, J) :  L*1 - F: NOT FLAT, T : FLAT
C    LSW (4, J) :  L*1 - F: ON AXIS, T : OFF AXIS
C    LSW (5, J) :  L*1 - F: NOT ANNULAR OBSC, T : ANNULAR OBSC
C    LSW (6, J) :  L*1 - F: NOT RECTANGULAR OBSC, T : RECTANGULAR OBSC
C    LSW (8, J) :  L*1 - F: NOT TOROIDAL, T : TOROIDAL
C    LSW0(1) :  L*1 - F: CONVENTIONAL, T : X-RAY SYSTEM
C
C  OUTPUT VIA LABELED COMMON /AXOFF/:
C    CB :  R*4 - COS (BETA) WHERE BETA IS THE BORESIGHT ANGLE, OR
!                COS (ZROT8) WHERE ZROT8 IS THE RECT OBSC ROT ANGLE
C    CE :  R*4 - CB * PHIL WHERE PHIL IS THE SCALING FACTOR = 1/R2S
C    SB :  R*4 - SIN (BETA), OR SIN (ZROT8)
C    SE :  R*4 - SB * PHIL
C    YEP:  R*4 - Y COORD. OF EPICENTER
C
C  OUTPUT VIA LABELED COMMON /COMIC/:
C    PHIL :  R*4 - 2/L FOR X-RAY, 1/R2S FOR CONVENTIONAL SYSTEM
C
C  OUTPUT VIA LABELED COMMON /RAIN/:
C    Q0 :  R*4 - SYMMETRIC STORAGE MODE UN-NORMALIZED 2ND
C                DERIVATIVE MATRIX OF SURFACE 'F' FUNCTION
C
C  OUTPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/:
C    V#9  :  NORMAL TO FOLD PLANE
C    V#11 :  DIRECTION COSINES OF BCS X AXIS WRT STD
C    V#12 :  DIRECTION COSINES OF BCS Y AXIS WRT STD
C    V#13 :  DIRECTION COSINES OF BCS Z AXIS WRT STD
C    V#14 :  ORIGIN OF BCS WRT STD
C    V#20 :  FOLD ORIGIN WRT BCS
!  (FOLLOWING ASSIGNMENT HAD BEEN TO V#2 - SEE CHANGES IN NEXRAP)
C    V#40 :  DIRECTION COSINES OF RAY BUNDLE WRT STD
C
C  EXTERNAL REFERENCES: VAZELD, VORTHO, VROT8, VSTOR
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/comic.h'     ! xd,yd,zd,xl,yl,zl,xg,yg,zg,phil
      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/rain.h'      ! 
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      COMMON /AXOFF/ CB, CE, SB, SE, YEP
      DOUBLE PRECISION B, AZ, EL, DAZ, DEL
      DOUBLE PRECISION      RAD
      parameter ( RAD = 17.45329 25199 43296 D-03 )
C
      CALL VSTOR (14, SURF(1,KURF), SURF(2,KURF), SURF(3,KURF))
      AZ = SURF(7,KURF)
      EL = SURF(8,KURF)
      PHIL = 1.0 / SURF(10,KURF)
C
C  CHECK SURFACE FOR FLATNESS
      IF (LSW (3, KURF)) GOTO 100
C
C  USE THE TOROIDAL ROTATION ANGLE AS A NEW ARGUMENT TO VORTHO
C  IF THE SURFACE IS A TOROID
C
      ZROT8 = 0.D0
      IF (LSW (8, KURF)) ZROT8 = SURF (11, KURF)
      CALL VORTHO (AZ, EL, ZROT8, 11, 12, 13)
!
!  CHECK SURFACE FOR OBSCURATION-TYPE
      IF (LSW (5, KURF) .OR. LSW (6, KURF)) GO TO 200
!
!  CHECK SURFACE FOR TOROIDAL-TYPE
!
      IF (LSW (8, KURF)) GO TO 250
C
C  ** ADDITIONS - BEFORE CHECKING FOR X-RAY, INITIALIZE Q0 **
C  EVALUATE P - 1
      P1 = SURF (4, KURF) - 1.D0
      Q0 (1) = 1.D0 + P1 * XV (13) * XV (13)
      Q0 (2) =        P1 * XV (13) * YV (13)
      Q0 (3) = 1.D0 + P1 * YV (13) * YV (13)
      Q0 (4) =        P1 * XV (13) * ZV (13)
      Q0 (5) =        P1 * YV (13) * ZV (13)
      Q0 (6) = 1.D0 + P1 * ZV (13) * ZV (13)
C  ** END OF ADDITIONS **
C
C  CHECK FOR X-RAY OR CONVENTIONAL SURFACE
      IF (LSW (9, KURF)) GOTO 50
C
C  OFF AXIS SURFACE
      IF (.NOT. LSW(4,KURF)) GOTO 300
         B = RAD * SURF (9, KURF)
         CB = DCOS(B)
         SB = DSIN(B)
         CE = PHIL * CB
         SE = PHIL * SB
         YEP = SURF (6, KURF)
         GOTO 300
C
50    PHIL = 2.0 * PHIL
      GOTO 300
C
C  STORE FOLD NORMAL IN V#9
100   DAZ = AZ
      DEL = EL
      AZ = SURF (4, KURF)
      EL = SURF (5, KURF)
      CALL VAZELD (AZ, EL, 9)
C
C  ESTABLISH BCS FOR FLAT SURFACE
      AZ = AZ + DAZ
      EL = EL + DEL
      CALL VORTHO (AZ, EL, 0.D0, 11, 12, 13)
C
C  FIND FOLD ORIGIN AND NORMAL WRT BCS
      CALL VSTOR (20, 0.0D0, 0.0D0, SURF (6, KURF))
      CALL VROT8 (20, 9, 14, 11, 12, 13, 20, 9)
!
      GO TO 300
!
!  PERFORM INITIALIZATION FOR OBSCURATION-TYPE SYSTEM
200   B = RAD * SURF (6, KURF)
      CB = DCOS(B)
      SB = DSIN(B)
      GO TO 300
!
!  PERFORM INITIALIZATION FOR TOROIDAL SURFACE
250   B = RAD * SURF (11, KURF)
      CB = DCOS(B)
      SB = DSIN(B)
C
300   AZ = GEN(7)
      EL = GEN(8)
!
!  CHANGE ASSIGNMENT TO V#40
!     CALL VAZELD (AZ, EL, 2)
!
      CALL VAZELD (AZ, EL, 40)
C
CBUG  CALL WRIT8 ('-X X X X', 8, 23, XV)
CBUG  CALL WRIT8 ('-Y Y Y Y', 8, 23, YV)
CBUG  CALL WRIT8 ('-Z Z Z Z', 8, 23, ZV)
      RETURN
      END
