!+
!KWIC vunit.f
!
!$Id: vunit.f,v 1.2 2004/03/17 21:23:44 dtn Exp $
!
!Revisions:
!   95-Oct-10[T. Gaetz]
!      . eliminate output to unit 6
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!      . change to IMPLICIT NONE
!-
      SUBROUTINE VUNIT (I, IUNIT, SIZE)
C   /******************************************/
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    VUNIT FORTRAN
C    *    WRITTEN BY JOHN LEGG
C    *            ON 06/05/80
C    *
C    *    UPDATE:   05/12/81
C    *    TIME:     16:22:21
C    *
C    ******************************************/
C  PURPOSE : CONVERT A VECTOR TO A UNIT VECTOR
C  PGM H. JACKSON 07/11/78
C
C  WHERE :
C  I - INDEX OF INPUT VECTOR
C  IUNIT - DESIRED LOCATION FOR UNIT VECTOR
C  SIZE  - RETURNED AS MAGNITUDE OF INPUT VECTOR
C
C  SUBPROGRAMS CALLED : DSQRT
C
C
      IMPLICIT DOUBLE PRECISION  (A - H, O - Z)
      IMPLICIT INTEGER (I-N)

      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      DOUBLE PRECISION SIZE
      INTEGER          I, IUNIT

      DOUBLE PRECISION D

      SIZE = DSQRT (XV (I) ** 2 + YV (I) ** 2 + ZV (I) ** 2)
      IF (SIZE .EQ. 0.D0) GO TO 100
      D = 1.0 / SIZE
      XV (IUNIT) = XV(I) * D
      YV (IUNIT) = YV(I) * D
      ZV (IUNIT) = ZV(I) * D
      RETURN
100   continue
      CALL INCLIN (1)
      WRITE (8, 900)
      RETURN
900   FORMAT ('  VUNIT - ARGUMENT VECTOR WAS ZERO')
      END
