!+
!KWIC wran.f
!
!$Id: wran.f,v 1.2 2004/03/17 21:23:45 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /RAIN/:  add save statement; move to include file
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-
!
!  UPDATED 2/7/88 TO WRITE THE POLARIZATIOND DATA
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 5/9/88 TO CURE FORMAT PROBLEM FOR RAY ALONG (0,0,-1)
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE WRAN (J, KX, LD) !*** SLASHES TAKEN OUT
C   /******************************************/
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    WRAN FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 05/21/80
C    *
C    *    UPDATE:   11/30/81
C    *    TIME:     13:48:14
C    *
C    ******************************************/
C
C  WRITE DATA RECORDS OF RAY FILES FOR NABRAT
C
C  INPUT ARGUMENTS :
C    J   : I*4 SURFACE #
C    KX  : I*4 IV# RAY INTERSECTION WRT STD
C    LD  : I*4 IV# RAY DIRECTION    WRT STD
C
C  INPUT VIA LABELED COMMON /RAIN/:
C    FOP  : FRACTIONAL PORTION OF PATH LENGTH
C    IOP  : INTEGER PORTION OF PATH LENGTH
C    JRAY : CURRENT RAY NUMBER
C    JING : CURRENT RING NUMBER
C    J2   : CURRENT SPOKE NUMBER
C    KODE : RAY STATUS CODE (SEE CHEX OUTPUT)
C    W    : RELATIVE INTENSITY OF RAY
C    Q0   : CURVATURE MATRIX OF WAVEFRONT (CURRENTLY NOT DEFINED)
C    C2COMP: C*16 - 2-D COMPLEX AMPLITUDE OF COS (OMEGA T) POLARIZATION
C    S2COMP: C*16 - 2-D COMPLEX AMPLITUDE OF SIN (OMEGA T) POLARIZATION
C
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/:
C    V#KX : POSITION OF RAY INTERSECTION
C    V#LD : DIRECTION OF RAY AFTER REFLECTION
C
C  OUTPUT VIA D#24: RAY001, D#26: RAY002, D#27: RAY003
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/rain.h'      !
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      DIMENSION QDUM (3)
      DOUBLE PRECISION P(6)
      INTEGER * 4  M (5)
      DATA QDUM /3 * 0.D0/
C
      JDEV = 22 + J + J
      IN10 = 1.0E8 * W + 0.5
      M(1) = JRAY
      M(2) = JING
      M(3) = J2
      M(4) = KODE
      M(5) = IN10
      IF (KODE .GE. 5) GO TO 10
      WRITE (JDEV, 101) M, QDUM
      P (1) = XV(KX)
      P (2) = YV(KX)
      P (3) = ZV(KX)
      P (4) = XV(LD)
      P (5) = YV(LD)
      P (6) = ZV(LD)
!
!  (INCLUDE THE NEWLY DEFINED POLARIZATION CARD AT THE END)
!  DON'T LET P (6) BE -1.000...
!     WRITE (JDEV, 102) P, IOP, FOP, QDUM, QDUM, C2COMP, S2COMP
!
      IF (P (6) .NE. -1.D0)
     *   WRITE (JDEV, 102) P, IOP, FOP, QDUM, QDUM, C2COMP, S2COMP
      IF (P (6) .EQ. -1.D0)
     *   WRITE (JDEV, 1021) (P (II), II = 1, 5),
     *                      IOP, FOP, QDUM, QDUM, C2COMP, S2COMP
!
      GO TO 30
C
10    CONTINUE
C  RAY FAILED
      DO 20 KDEV = JDEV, 28, 2
      WRITE (KDEV, 101) M, QDUM
20    CONTINUE
C
30    RETURN
101   FORMAT (5I10, 3F10.6)
102   FORMAT (1P, 3E25.17,   /, 3E25.17, 1X, I5, E25.17,   /,
     1        3(E25.17,1X),    3(E25.17,1X), /,
     2        4(E25.17,1X), /, 4(E25.17,1X) )
1021  FORMAT (1P,3E25.17 / 2E25.17, '-9.999999999999999999d+00',
     *                             I5, F15.12 / 3F12.9, 4X, 3F12.9 /
     1        4F15.9 / 4F15.9)
      END
