!+
!KWIC wrgrid.f
!
!$Id: wrgrid.f,v 1.2 2004/03/17 21:23:45 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /IDENT/:  add save statement; move to include file
!
!  UPDATED 5/9/88 TO MAKE DFID CHARACTER * 4
!  PAUL GLENN, BAUER ASSOICATES, INC.
!
!-
      SUBROUTINE WRGRID
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    WRGRID FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 09/22/81
C    *
C    *    UPDATE:   02/11/82
C    *    TIME:     10:48:25
C    *
C    ******************************************/
C
C  WRITE THE (BINARY) FOCAL PLANE PIXEL ARRAY TO UNIT 4
C
C  INPUT VIA LABELED COMMON /IDENT/ :
C    GID   : R*4 - 64 CHARACTER GI FILE IDENTIFIER LINE
C    GDATE : CHAR*8 - 8 CHARACTER DATE
C    GTIME : R*8 - 8 CHARACTER TIME
C    RID   : R*4 - 64 CHARACTER SCAT FILE IDENTIFIER LINE
C    RDATE : CHAR*8 - 8 CHARACTER DATE
C    RTIME : R*8 - 8 CHARACTER TIME
C
C  INPUT VIA LABELED COMMON /FPGRCO/ :
C    FPGRID (I) : R*4 - FOCAL PLANE PIXEL ARRAY
C
C  INPUT VIA LABELED COMMON /PARAMS/ :
C    ZLAM : R*4 - WAVELENGTH
C
C  INPUT VIA LABELED COMMON /TABLES/ :
C    FOGR (I) : R*4 - ARRAY OF FOCAL PLANE ARRAY DEFINITION PARAMETERS
C
C  OUTPUT VIA UNIT # 4 :
C    BINARY FILE WITH FOLLOWING RECORDS :
C      1 : RID (1 - 16), RDATE, RTIME (1) = SCAT FILE IDENTIFIER LINE
C      2 : GID (1 - 16), GDATE, GTIME (1) = GI FILE IDENTIFIER LINE
C      3 : FOGR (1) -- FOGR (6)  (FOGR (5) = NX = # OF COLUMNS)
C                                (FOGR (6) = NY = # OF ROWS)
C          ZLAM = WAVELENGTH
C          ITYPE = 1 FOR FTYPE 'SCATTER' (AS OPPOSED TO 'DIFFRACTION')
C      4 : FPGRID (1) -- FPGRID (NX) = FIRST ROW
C      5 : FPGRID (NX+1) -- FPGRID (2*NX) = SECOND ROW
C      ETC.
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/ident.h'     ! misc identifiers (times, dates, ...)

      COMMON /FPGRCO/ FPGRID (1)
      COMMON /PARAMS/ ZLAM, ZK, ZW (21), DP0 (21),
     1  DP1S (210), DP1T (210), SFX (21), SFY (21), TFX (21), TFY (21),
     2  METARR (21)
      COMMON /TABLES/ FOGR (6), V2TAB (801, 5), GTAB (800, 5),
     1  GTAB1 (800, 5), GTAB2 (800, 5), GTAB3 (800, 5),
     2  STHTAB (801), REFTAB (800), VZSTAB (101), FVSTAB (100),
     3  SIGSQ (3, 5), GR0 (3, 5), ACCG, ACCR, ACCF, METSYS (8)
      DOUBLE PRECISION FOGR
C
C
C  WRITE OUT IDENTIFIERS
      WRITE (4) RID, RDATE, RTIME (1)
      WRITE (4) GID, GDATE, GTIME (1)
C
C  SET TOTAL NUMBER OF COLUMNS AND ROWS
      NX = FOGR (5)
      NY = FOGR (6)
C
C  WRITE OUT FOGR , ZLAM, AND ITYPE = 1
      ITYPE = 1
      WRITE (4) FOGR, ZLAM, ITYPE
C
C  LOOP OVER EACH ROW
      DO 200 J = 1, NY
      IBOT = (J - 1) * NX + 1
      ITOP = IBOT + NX - 1
C  (WRITE OUT THE ROW)
      WRITE (4) (FPGRID (I), I = IBOT, ITOP)
200   CONTINUE
      RETURN
      END
