!+
!KWIC wropd.f
!
!$Id: wropd.f,v 1.2 2004/03/17 21:23:45 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /RAIN/:  add save statement; move to include file
!   95-Oct-10[T. Gaetz]
!      . eliminate output to unit 6
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 5/17/89 TO CURE FORMAT PROBLEM FOR RAY ALONG (0,0,-1)
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-
!
!  UPDATED 2/26/88 TO WORK WITH EXPANDED RAY FILES
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 5/9/88 TO ALLOW FOR FINITE DISTANCE POINT SOURCE
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE WROPD (OPDBAR, OPSSUM, IER)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    WROPD FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 10/28/81
C    *
C    *    UPDATE:   12/10/81
C    *    TIME:     13:17:38
C    *
C    ******************************************/
C
C  CALCULATE AND OUTPUT OPD RECORDS FOR EACH RAY (ALSO TRAILER RECORD)
C
C  INPUT PARAMETER :
C    OPDBAR : R*8 - AVERAGE OPD FOR ALL RAYS
C
C  INPUT VIA # 3 : RAY PARAMETERS AT FOCAL PLANE
C
!  (FILE # 7 DESCRIBED BELOW IS NO LONGER USED - 5/9/88)
C  INPUT VIA # 7 : RAY PARAMETERS AT FIRST SURFACE
C
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/ :
C    V # 5 : COORDINATES OF BEST FOCUS IN FOCAL PLANE
C    V # 9 : DIRECTION COSINES OF INCOMING BUNDLE
C
C  OUTPUT PARAMETERS :
C    OPSSUM : R*8 - RUNNING WEIGHTED SUM OF SQUARE OF OPD
C    IER    : I*4 -  -1 = NO RAYS LEFT, TRAILER COMPLETED
C                    1  = MORE RAYS TO COME
C
C  XR : VDOT, VLINE
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/rain.h'      !
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      DOUBLE PRECISION VDOT
      DOUBLE PRECISION OPD, OPSSUM, OPDI, OPDBAR, WF2, WS2
!!!   DOUBLE PRECISION FOP2
      DATA INIT /1/
C
C
C  READ FIRST LINE FROM FOCAL PLANE FILE, CHECK FOR TRAILER
      READ (3, 8000, ERR = 2100, END = 2200) JRAY, JING, J2, KODE, IN10
      IF (JRAY .LT. 0) GO TO 1500
C
C  NOT TRAILER - READ AND CHECK FIRST SURFACE INFO
      IER = 1
!
!     READ (7, 8000, ERR = 2100, END = 2200) JRAY2, JING2, J22, KODE2,
!    1                                                          IN102
!     IF (JRAY .NE. JRAY2 .OR. KODE .LT. KODE2) GO TO 2000
!
      WRITE (4, 8000, ERR = 2100) JRAY, JING, J2, KODE, IN10
C                        !*** TOOK OUT 'END = 2200' FROM WRITE STATEMENT
C
C  CHECK IF RAY SUCCESSFUL FOR FURTHER PROCESSING
      IF (KODE .LE. 4) GO TO 500
C
C  NOT SUCCESSFUL - POSSIBLY SKIP RECORDS IN FIRST SURF FILE, EXIT
!  (READ TWO MORE RECORDS)
!
!     IF (KODE2 .LE. 4) READ (7, 8010) DUM, DUM, DUM, DUM, DUM
!
      GO TO 1900
C
C  SUCCESSFUL - CALCULATE AND OUTPUT OPD INFO
!  (READ THE POLARIZATION DATA)
!  (REVERSE THE ORDER OF THE READS, SO THAT THE POLARIZATION DATA
!  WILL APPLY TO THE FINAL SURFACE, NOT THE FIRST SURFACE)
!
!  (5/9/88 - ELIMINATE THE FIRST SURFACE READ)
!
!500  READ (7, 8020, ERR = 2100, END = 2200) XV (12), YV (12), ZV (12),
!    1               XV (13), YV (13), ZV (13), IOP2, FOP2,
!    2               Q3, C2COMP, S2COMP
!
500   READ (3, 8020, ERR = 2100, END = 2200) XV (10), YV (10), ZV (10),
     1               XV (11), YV (11), ZV (11), IOP, FOP,
     2               Q3, C2COMP, S2COMP
      IF (INIT .EQ. -1) GO TO 540
      IOPINI = IOP
      INIT = -1
540   IOPDEL = IOP - IOPINI
      OPDI = IOPDEL + FOP + VDOT (5, 11) - VDOT (10, 11)
      OPD = OPDI - OPDBAR
      OPSSUM = OPSSUM + OPD * OPD * IN10 * 1.D-8
!
!  IN THE FOLLOWING CALCULATIONS, THE PREVIOUS VERSION PROPAGATED
!  THE RAY BACKWARDS FROM THE FIRST SURFACE INTERSECTION (V#12), ALONG
!  THE COLLIMATED BUNDLE DIRECTION (V#9), TO THE PUPIL PLANE (Z=0)
!  (THUS, BY A DISTANCE OF THE FIRST SURFACE OPD=(IOP2+FOP2)),
!  PUTTING THE RESULTS IN V#8.
!
!     CALL VLINE (12, - (IOP2 + FOP2), 9, 8)
!     ZV (8) = 0.D0
!
!  THE FOLLOWING REVISED CODE ACCOMPLISHES TWO THINGS.  FIRST, IT
!  CORRECTS A CONCEPTUAL BUG IN THE PREVIOUS CODE: THE PREVIOUS CODE
!  ASSUMED THAT THE PATH LENGTH FROM THE PUPIL TO THE FIRST SURFACE
!  WAS GIVEN BY (IOP2+FOP2), THE FIRST SURFACE OPL. THIS WAS WRONG,
!  SINCE THERE IS ALREADY AN OPL CONTRIBUTION AT THE PUPIL FOR
!  AN OFF-AXIS COLLIMATED BUNDLE.  SECONDLY, THIS NEW CODE ALLOWS
!  FOR A FINITE DISTANCE POINT SOURCE, SO THAT EACH RAY HAS ITS OWN
!  INCOMING DIRECTION, NOT NECESSARILY THE SAME AS FROM THE POINT
!  SOURCE TO THE PUPIL CENTER.  THE FOLLOWING CODE UTILIZES A PREVIOUS
!  CALL TO NEXRAP, WHICH PUT THE PUPIL POSITION INTO V#1.  THIS
!  ELIMINATES THE NEED TO PROPAGATE THE RAY BACKWARDS.
!
!     WRITE (4, 8030) XV (8), YV (8), ZV (8),
!    1                XV (11), YV (11), ZV (11), OPD
!
!  DON'T LET ZV (11) BE -1.000...
!     WRITE (4, 8030) XV (1), YV (1), ZV (1),
!    1                XV (11), YV (11), ZV (11), OPD
!
      IF (ZV (11) .NE. -1.D0)
     *  WRITE (4, 8030) XV (1), YV (1), ZV (1),
     *                  XV (11), YV (11), ZV (11), OPD
      IF (ZV (11) .EQ. -1.D0)
     *  WRITE (4, 8031) XV (1), YV (1), ZV (1),
     *                  XV (11), YV (11), OPD
      GO TO 1900
C
C  TRAILER RECORD - PROCESS AND EXIT
1500  IER = -1
      WRITE (4, 8000, ERR = 2100) JRAY, JING, J2, KODE, IN10
C                      !*** TOOK OUT 'END=2200' FROM READ AND WRITE STATEMENT
      READ (3, 8040, ERR = 2100, END = 2200) WF2, WS2
      WRITE (4, 8040) WF2, WS2
C
1900  RETURN
C
!
!2000 continue
!     WRITE (8, 8100) JRAY, JRAY2, KODE, KODE2
!     STOP 8
!
2100  continue
      WRITE (8, 8110)
      STOP 8
2200  continue
      WRITE (8, 8120)
      STOP 8
C
8000  FORMAT (5I10)
!
!  READ TWO MORE LINES IN THE FOLLOWING 2 STATEMENTS
!
8010  FORMAT (A4 / A4 / A4 / A4 / A4)
8020  FORMAT (1P,3D25.17 / 3F20.17, I5, F15.12 / 3F12.9, 4X, 3F12.9 /
     1        4F15.9 / 4F15.9)
8030  FORMAT (1P,3D25.17 / 3F21.17, D16.6)
8031  FORMAT (1P,3D25.17 / 2F21.17, '-9.99999999999999999', D16.6)
8040  FORMAT (1P,2D20.12)
!
!8100 FORMAT ('  WROPD - FATAL ERROR IN RAY FILE PARAMETERS -' /
!    1  '    RAY NUMBER (FINAL, FIRST SURF) :', 2I10 /
!    2  '    RAY STATUS (FINAL, FIRST SURF) :', 2I10)
!
8110  FORMAT ('  WROPD - FATAL ERROR - ERROR WHILE READING RAY FILE')
8120  FORMAT ('  WROPD - FATAL ERROR - EOF WHILE READING RAY FILE')
      END
