!+
!KWIC wrsub.f
!
!$Id: wrsub.f,v 1.2 2004/03/17 21:23:45 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SUMRY/:  add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!-
!
!  UPDATED 2/26/88 TO ELIMINATE SINE-OF-GRAZING-ANGLE SCALE FACTORS,
!  SINCE REFLECTIVITY VARIATIONS ARE ELIMINATED
!
      SUBROUTINE WRSUB (SFX, SFY, TFX, TFY, DP0, DP1S, DP1T, J)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    WRSUB FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5521
C    *            ON 05/08/81
C    *
C    *    UPDATE:   05/21/81
C    *    TIME:     14:34:31
C    *
C    ******************************************/
C
C  PURPOSE :  TO UPDATE RUNNING SUMS OF SQUARES OF SCALE FACTORS AND
C             TO WRITE SCALE FACTOR INFORMATION TO THE 'SCALE' FILE
C
C  INPUT PARAMETERS :
C     SFX  :  X-COMP OF SAGITTAL SCALE FACTOR
C     SFY  :  Y-COMP OF SAGITTAL SCALE FACTOR
C     TFX  :  X-COMP OF TANGENTIAL SCALE FACTOR
C     TFY  :  Y-COMP OF TANGENTIAL SCALE FACTOR
C     DP0  :  BASELINE SIN OF GRAZING ANGLE AT SURF # J
C     DP1S :  SAGITTAL DERIVATIVE OF SIN OF GRAZING ANGLE
C     DP1T :  TANGENTIAL DERIVATIVE OF SIN OF GRAZING ANGLE
C     J    :  SURFACE NUMBER
C
C  INPUT VIA /PARX/ :
C     NS :  NUMBER OF SURFACES
C
C  INPUT VIA /SWITCH/ :
C     LSW0 (1) :  X-RAY SYSTEM SWITCH
C
C  OUTPUT VIA /SUMRY/ :
C     STAV (1, J) :  RUNNING SUM OF MAGNITUDES OF SAGITTAL SCALE FACTORS
C     STAV (2, J) :  DITTO FOR TANGENTIAL SCALE FACTORS
C
C  OUTPUT :
C     INPUT PARAMETERS WRITTEN TO D # 2 ('SCALE' FILE)
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)

      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/sumry.h'     ! data for summaries
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw

      DIMENSION DP1S (21), DP1T (21)
C
C
C  UPDATE STAV
      SFSQ = SQRT (SFX * SFX + SFY * SFY)
      TFSQ = SQRT (TFX * TFX + TFY * TFY)
      STAV (1, J) = STAV (1, J) + SFSQ
      STAV (2, J) = STAV (2, J) + TFSQ
C
C  WRITE FOCAL PLANE SCALE FACTORS, BASELINE SIN OF GRAZING ANG
      WRITE (2, 900) SFX, SFY, TFX, TFY, DP0
!
!C
!C  IF X-RAY SYSTEM, WRITE DERIVATIVES OF SINS OF GRAZING ANGLES
!      IF (.NOT. LSW0 (1)) GO TO 500
!C  SET NUMBER OF GRAZING ANGLE SCALE FACTORS
!      NFACT = NS - J
!      IF (NFACT .EQ. 0) GO TO 500
!C  SET NUMBER OF OUTPUT LINES
!      NLINE = INT ((NFACT + 2.) / 3.)
!C  LOOP FOR EACH OUTPUT LINE
!      DO 150 N = 1, NLINE
!      KBOT = 3 * N + J - 3
!      KTOP = KBOT + 2
!      IF (KTOP .GT. NS - 1) KTOP = NS - 1
!      WRITE (2, 910) (DP1S (K), DP1T (K), K = KBOT, KTOP)
!150   CONTINUE
!
500   RETURN
C
900   FORMAT (1P,5E13.5)
910   FORMAT (1P,6E13.5)
      END
