!+
!KWIC zbuild.f
!
!$Id: zbuild.f,v 1.1 2004/03/16 15:50:17 dtn Exp $
!
!Revisions:
!   95-Feb-01[T. Gaetz]
!      . change IWK1, IWK2, COFMAT to assumed-size (for bounds-checking)
!-
      SUBROUTINE ZBUILD (NZERKS, OBSC, IWK1, IWK2, NNDX, NDXARR, COFMAT)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    ZBUILD FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 4/1/88
C    *
C   /******************************************/
C
C  PURPOSE: BUILD A SET OF COEFFICIENTS WHICH DEFINE ZERNIKE
C           POLYNOMIALS ORTHONORMALIZED OVER AN ANNULUS
C
C  INPUT PARAMETERS:
C    NZERKS: I*4 - NUMBER OF ZERNIKE POLYNOMIALS (INCLUDING BOTH
C                  COSINES AND SINES) WHICH WILL BE USED
C    OBSC: R*8 - LINEAR OBSCURATION RATIO
C    IWK1: I*4 - WORK ARRAY WITH A DIMENSION EQUAL TO THE LARGEST
C                NUMBER OF TERMS IN ANY OF THE POLYNOMIALS TO BE
C                DEFINED
C    IWK2: I*4 - WORK ARRAY WITH SAME DIMENSION AS IWK1
C    NNDX: I*4 - DIMENSION OF THE 2-D SQUARE OUTPUT ARRAY NDXARR
C
C  OUTPUT PARAMETERS:
C    NDXARR: I*4 - 2-D ARRAY (NNDX BY NNDX) OF INDICES INTO THE
C                  COFMAT ARRAY.  NDXARR (NORD+1, MORD+1) CONTAINS
C                  THE STARTING INDEX IN COFMAT OF THE ZERNIKE
C                  POLYNOMIAL WITH RADIAL ORDER NORD, AND AZIMUTHAL
C                  ORDER MORD.  NDXARR IS INITIALIZED TO ZEROES, SO
C                  THAT ENTRIES WITH NO CORRESPONDING POLYNOMIAL
C                  WILL HAVE A ZERO VALUE.  (IT IS THE USER'S
C                  RESPONSIBILITY TO BE SURE THAT NNDX IS LARGE
C                  ENOUGH TO ACCOUNT FOR ALL NZERKS POLYNOMIALS.)
C    COFMAT: R*8 - ARRAY OF COEFFICIENTS DEFINING THE ZERNIKES - THE
C                  COEFFICIENTS ARE ORDERED AS A SET OF BLOCKS, EACH
C                  SUCCEEDING BLOCK DEFINING ANOTHER POLYNOMIAL.  THE
C                  BLOCKS ARE NOT ORDERED IN THE STANDARD OSAC ZERNIKE
C                  ORDER.  INSTEAD, THEY ARE ORDERED IN FAMILIES.
C                  (FAMILIES ARE DEFINED BY THE LOWEST RADIAL ORDER,
C                  WHICH IS COMMON TO ALL POLYNOMIALS IN THE FAMILY.)
C                  THE COARSEST ORDERING IS BY FAMILIES, WHICH ARE
C                  ORDERED IN INCREASING LOWEST ORDER.  THE ORDERING
C                  OF BLOCKS (OR POLYNOMIALS) WITHIN A FAMILY IS BY
C                  INCREASING POLYNOMIAL ORDER.  THE ORDERING WITHIN
C                  A BLOCK (OR POLYNOMIAL) IS BY DECREASING POWER OF R.
C
C  NOTE ON INTERNAL STORAGE: USING THE CURRENT OSAC MAXIMUM OF 325
C       ZERNIKE POLYNOMIALS, THE LARGEST NUMBER OF TERMS IN ANY
C       POLYNOMIAL IS 13, THE MAXIMUM RADIAL ORDER IS 24 (I.E., THERE
C       ARE 25 RADIAL DEGREES OF FREEDOM), AND THE MAXIMUM TOTAL NUMBER
C       OF COEFFICIENTS IN THE COFMAT OUTPUT ARRAY IS 819.  THESE
C       NUMBERS DETERMINE THE DIMENSIONS REQUIRED OF THE CALLING
C       PROGRAM'S ARRAYS.
C
C  EXTERNAL REFERENCES: SBUILD
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)
      DIMENSION IWK1 (*), IWK2 (*)
      DIMENSION NDXARR (NNDX, NNDX), COFMAT (*)
C
C
C  INITIALIZE THE ARRAY OF COFMAT INDICES
C
      DO 110 I = 1, NNDX
      DO 100 J = 1, NNDX
      NDXARR (I, J) = 0
100   CONTINUE
110   CONTINUE
C
C  FIND OUT HOW MANY FAMILIES OF POLYNOMIALS NEED TO BE DEFINED
C  (EACH FAMILY IS DEFINED BY NBOT, THE LOWEST RADIAL ORDER IN
C  IT, WHICH IS COMMON TO ALL THE POLYNOMIALS IN THE FAMILY.  THE
C  LOWEST RADIAL ORDER IS EQUAL TO THE AZIMUTHAL ORDER OF THE
C  SINE OR COSINE WHICH WILL EVENTUALLY BE MULTIPLIED BY THE
C  RADIAL POLYNOMIAL TO GIVE A ZERNIKE POLYNOMIAL.
C
      NFTEST = 2
120   NZTEST = (NFTEST * (NFTEST + 1)) / 2 - 1
      IF (NZTEST .GT. NZERKS) GO TO 150
      NFTEST = NFTEST + 1
      GO TO 120
150   NFAM = NFTEST - 1
C
C  LOOP OVER THE FAMILIES OF POLYNOMIALS
C
      NDX = 1
      DO 290 IFAM = 1, NFAM
      NBOT = IFAM - 1
C
C  FIND OUT HOW MANY MEMBERS THERE ARE IN THE LOWEST-ORDER-NBOT FAMILY
C  (THE CALCULATIONS BELOW DETERMINE K, WHICH IS THE ZERNIKE
C  POLYNOMIAL NUMBER IN THE OSAC ORDERING CONVENTION, FOR THE J'TH
C  MEMBER OF THE FAMILY)
C
200   IQ = 1
      IF (NBOT .GT. 0) IQ = ((NBOT + 1) * (NBOT + 2)) / 2 - 1
      J = 1
220   K = IQ + (J - 1) * (2 * NBOT + 2 * J - 1)
      IF (K .GT. NZERKS) GO TO 250
      J = J + 1
      GO TO 220
250   NPOLYS = J - 1
C
C  FIND THE COEFFICIENTS THAT DEFINE THE LOWEST-ORDER-NBOT FAMILY
C  (THERE ARE (NPOLYS) DIFFERENT POLYNOMIALS, AND A TOTAL OF
C  ((NPOLYS*(NPOLYS+1))/2) COEFFICIENTS IN THE FAMILY)
C
      write( *, * ) 
     &  'nbot, npolys, ndx, obsc ', nbot, npolys, ndx, obsc
      CALL SBUILD (NBOT, NPOLYS, OBSC, IWK1, IWK2, COFMAT (NDX))
C
C  UPDATE THE COFMAT INDICES FOR THE POLYNOMIALS IN THIS FAMILY
C
      MORD = NBOT
      DO 280 IPOLY = 1, NPOLYS
      NORD = NBOT + 2 * (IPOLY - 1)
      NDXARR (NORD + 1, MORD + 1) = NDX
      NDX = NDX + IPOLY
280   CONTINUE
290   CONTINUE
      END
