#============================================================================
# copy_dir.mk

COPY_DIR_MK =

# this snippet defines a sequence of shell commands which will
# recursively copy a directory to a destination. it first checks for
# the directory in the current directory;  if it is not found there,
# it assumes it is in $srcdir.
#
# To use this, set these shell variables
#
#  source_dir - the directory holding the original files
#  dest_dir   - the directory where the files are to be installed
#
# and then interpolate $(copy_dir).  For example
#
#  source_dir=$(_HTML); dest_dir=$(htmldir); $(copy_dir)

# prerequisite check
CREATE_AM_MACROS_MK +=

copy_dir =	\
	$(mkinstalldirs) $(DESTDIR)$$dest_dir; \
	if test -d "$$source_dir"; then d=; else d="$(srcdir)/"; fi; \
	for p in $$d$$source_dir/*; do \
	  f=$(strip_dir); \
	  echo " cp -R $$p $(DESTDIR)$$dest_dir/$$f"; \
	  cp -R $$p $(DESTDIR)$$dest_dir/$$f; \
	done
