.\" -*- mode: troff; coding: utf-8 -*-
.\" Automatically generated by Pod::Man 5.01 (Pod::Simple 3.43)
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" \*(C` and \*(C' are quotes in nroff, nothing in troff, for use with C<>.
.ie n \{\
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds C`
.    ds C'
'br\}
.\"
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\"
.\" If the F register is >0, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.SS), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.\"
.\" Avoid warning from groff about undefined register 'F'.
.de IX
..
.nr rF 0
.if \n(.g .if rF .nr rF 1
.if (\n(rF:(\n(.g==0)) \{\
.    if \nF \{\
.        de IX
.        tm Index:\\$1\t\\n%\t"\\$2"
..
.        if !\nF==2 \{\
.            nr % 0
.            nr F 2
.        \}
.    \}
.\}
.rr rF
.\" ========================================================================
.\"
.IX Title "aotrace-env 1"
.TH aotrace-env 1 2025-11-25 1.1.5 "User Contributed Perl Documentation"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.if n .ad l
.nh
.SH NAME
.Vb 1
\& saotrace\-env \- output environment variables required to run SAOTrace
.Ve
.SH SYNOPSIS
.IX Header "SYNOPSIS"
.Vb 1
\& saotrace\-env [options]
\&
\& # output and evaluate zsh compatible shell commands
\& eval \`saotrace\-env \-\-fmt=zsh\`
\&
\& # output and evaluate bash compatible shell commands
\& eval \`saotrace\-env \-\-fmt=bash\`
\&
\& # output and evaluate csh compatible shell commands
\& eval \`saotrace\-env \-\-fmt=csh\`
.Ve
.SH DESCRIPTION
.IX Header "DESCRIPTION"
\&\fBsaotrace-env\fR generates environment variables required to run SAOTrace.
.PP
Typical use is to generate commands for a shell to set the environment
and evaluate those commands.  For example,
.PP
.Vb 1
\&  eval \`saotrace \-\-fmt=zsh\`
.Ve
.SH "OPTIONS AND ARGUMENTS"
.IX Header "OPTIONS AND ARGUMENTS"
.IP \-\-fmt=\fIformat\fR 4
.IX Item "--fmt=format"
Specify the output format.  To list all of the possible formats, set \f(CW\*(C`\-\-fmt=\-list\*(C'\fR.
.Sp
The available formats are:
.RS 4
.ie n .IP """bash"" | ""csh"" | ""dash"" | ""ksh"" | ""tcsh"" | ""zsh""" 4
.el .IP "\f(CWbash\fR | \f(CWcsh\fR | \f(CWdash\fR | \f(CWksh\fR | \f(CWtcsh\fR | \f(CWzsh\fR" 4
.IX Item "bash | csh | dash | ksh | tcsh | zsh"
Output commands to set the environment for the specified shell.
.IP yaml 4
.IX Item "yaml"
Output the environment variables as a YAML document
.RE
.RS 4
.RE
.IP \-\-help 4
.IX Item "--help"
output short usage instructions and exit
.IP \-\-manual 4
.IX Item "--manual"
output a manual page and exit
.IP \-\-list\-env\-vars 4
.IX Item "--list-env-vars"
list the names of the environment variables which are output
.IP \-\-version 4
.IX Item "--version"
output version informaiton and exit
.SH "RELOCATABLE EXECUTION"
.IX Header "RELOCATABLE EXECUTION"
The ability to move the SAOTrace installation to another location and
run it from there makes it \fIrelocatable\fR.
.PP
There are two components to making it relocatable.
.IP \(bu 4
At runtime SAOTrace needs access to bundled data, and finds them
via environment variables.
.IP \(bu 4
The system linker must locate all of the libraries which are used by
the executables.  Each operating system has a unique method of doing
so.  For Linux, it is possible to use the \f(CW\*(C`LD_LIBRARY_PATH\*(C'\fR
environment variable to override the paths written into the executable
and library binary files.  For Mac OS, the paths in the files must
be rewritten.
.PP
\&\fBsaotrace-env\fR can only modify environment variables; rwriting the
executable and library binary files must be done (once) by another
tool (e.g. finalize-saotrace).
.PP
To avoid having the user source a setup file to run SAOTrace, it is
possible (and is actually done in practice by finalize-saotrace) to
wrap the executable with a slim POSIX shell compatible wrapper, like so:
.PP
.Vb 5
\&  #!/bin/sh
\&  parent=${0%/*}/../
\&  test \-z "$SAOTRACE_BINDIR" && eval $(${parent}/bin/saotrace\-env \-\-fmt=sh)
\&  PATH="${parent}/xbin:${PATH}"
\&  exec @EXE@ "$@"
.Ve
.PP
where \f(CW\*(C`@EXE@\*(C'\fR is eplaced by the name of the executable. This relies upon
the original executable being available in a parallel path (\f(CW\*(C`xbin\*(C'\fR).
.SH "COPYRIGHT AND LICENSE"
.IX Header "COPYRIGHT AND LICENSE"
This software is copyright the Smithsonian Astrophysical Observatory
and is released under the GNU General Public License.  You may find a
copy at <http://www.fsf.org/copyleft/gpl.html>.
.SH AUTHOR
.IX Header "AUTHOR"
Diab Jerius <djerius@cfa.harvard.edu>
