*+
*KWIC init_surface_intercept.f
*
*Revisions:
*   1999-Jan-06[T. Gaetz]
*      . renamed from SAOdrat
*-
***** file: init_surface_intercept.f

*+**********************************************************************
      integer function init_surface_intercept( )
************************************************************************
*
*kwic init_surface_intercept --- initialization of saodrat
*
*  arguments:
*     rcsid_string -- ca, i  -- rcs id string
*
*  comments:
*
*  USER INPUTS :
*
*  via # 5 :  RID : 64 character ray file identifier
*             KURF : surface number
*
*  via # 13, when surface switch 2 = .true. : the deform file containing
*           DFID, NDF, and the deformation coefficients.
*
*  via # 23, when s# > 1 : the ray file for the previous surface.
*  NOTE : a ray file contains information on each ray
*    as it intersects a particular surface
*
*  USER OUTPUTS :
*  via # 6 : printed information about the ray tracE
*  via # 8 : printed information about the ray trace
*
*
*  via # 24 : current surface ray file
*  via # 26 : focal plane ray file
*
*  END OF USER INPUT & OUTPUT
*
*  INPUT via the OS supplied pgms DATE & TIME !***
*
*  Output via /PARM/ and /PARX/ :   (see GXIN)
*  Output via /DEFORM/ when surface switch 2 = .true.
*    NDF   : I*4 number of deformation termS
*    DEFC  : NDF*R*8 array of deformation coefficientS
*  Output via /IDENT/ :
*    RID   : ray file identifier
*    GID   : geometry identifier
*    DFID  : deformation identifier
*
*  XR : FOVEL, GXIN, HEDRAY, INCLIN, NEXRAY, OSACBL, PROGID, RAYDUM
*   REDECO, REHEAD, TRADER, TRALAY, VINIT, !***ZTIME
*   TIME, OSDATE, ZBUILD
*-
      implicit none

*---  named constants...
      INTEGER     LUNERR

      PARAMETER ( LUNERR = 0 )   ! unit number for 'stderr'
      DOUBLE PRECISION DEG2RAD
      PARAMETER      ( DEG2RAD = 1.d0 / 57.295779513082320876798155d0 )

*---  passed parameter...
!      CHARACTER*(*) rcsid_string
*     for debug options:
!      integer  db_extend   ! to extend data fields

*---  global variables...

      include 'saosacLib/deform.h'    ! fourier-legendre deformation coeffs
      include 'saosacLib/parm.h'      ! gen, surf
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/srfstuff.h'  ! some .gi surface parameters
      include 'saosacLib/raystuff.h'  ! info needed for binary pipeline
      include 'saosacLib/gparam.h'    

      DOUBLE PRECISION GTIME
      CHARACTER*(4)    GID, RID, DFID
      CHARACTER*(8)    GDATE , RDATE, RTIME, RDUMMY !*** WERE REAL*8
      COMMON /IDENT/   GID (16), GDATE, GTIME (2),
     1                 RID (16), RDATE, RTIME (2),
     2                 DFID (16)

      DOUBLE PRECISION AQ, WF1, WF2, WS1, WS2, XMIN, XMAX, YMIN, YMAX,
     1                 WX, WY, WR, WXSQ, WYSQ, STAV
      INTEGER          JAIL1, JAIL2, LEFT1, LEFT2
      COMMON /SUMRY/   AQ (10), WF1, WF2, WS1, WS2, JAIL1, JAIL2,
     1                 LEFT1, LEFT2, XMIN, XMAX, YMIN, YMAX,
     2                 WX, WY, WR, WXSQ, WYSQ, STAV (2, 21)

      LOGICAL *1       LSW0, LSW
      COMMON /SWITCH/  LSW0 (10),  LSW (10, 21)

*---  external routines...
      integer  len_trim
      external len_trim

*---  local variables
      integer         ln
      integer         ier !  for bpipe
      real*8          dfm_rms
*CODE init_surface_intercept -------------------------------------------

*---  data initializations...
      init_surface_intercept = 0

*---  Initialize no. of rays and weight
      LEFT1       = 0
      WS1         = 0.0d0

*---  Read in parameter file...    ! 11/3 fg.. added
!      will be called from a C-routine.
!      call getparam(db_extend) 
  
*===> ------------------------------------------------------------------

C*---  open log file...
C      open (  8, FILE = log_file )

*---  Identify program and its release number
*     and specify that the identifier has 2 lines

      CALL PROGID ('SAODRAT ', '01.00', 2)

*---  open the binary ray streams...
!      ln1 = len_trim(in)
!      ln2 = len_trim(out)
!
!      call attach_bpipe( in(:ln1), out(:ln2),db_extend,fgoodrays)

*---  Get rdate
      CALL SAODATE (RDATE)   !*** WAS ZTIME
      CALL SAOTIME (RDUMMY) 
      RTIME(1) = RDUMMY

*<=== ------------------------------------------------------------------

C*---  open the binary ray streams...

C     FOLLOWING DECISION BLOCK REPLACES lsw(10..) BLOCK
*--     read in the deformation file...
      IF (DFM_TYPE .EQ. 1) THEN     ! was 0, switched on 11/14
*---     Read the spline coefficients for the deformation
         ln  = len_trim( fnm_dfm )
         fnm_dfm(ln+1:ln+1) = char(0)    ! nul-terminate it
         call read_spline_data( fnm_dfm, 50, dfm_rms )
         DEFT = dfm_rms
         DEF2 = dfm_rms * dfm_rms
      ELSE IF (DFM_TYPE .EQ. 0) THEN  ! was 1, switched on  11/14  
*---     Read the Legendre-Fourier deformation coefficients
         open ( 13, FILE = fnm_dfm, STATUS ='OLD', 
     &              FORM = 'FORMATTED', ERR = 400 )
         CALL REDECO (13, 1, ier)
         close ( 13 )
         IF (ier .NE. 0) GO TO 210
      ELSE
C      ...both deformation types. spline first....
*---     Read the spline coefficients for the deformation
*---     Read the spline coefficients for the deformation
         ln  = len_trim( fnm_dfm )
         fnm_dfm(ln+1:ln+1) = char(0)    ! nul-terminate it
         call read_spline_data( fnm_dfm, 50, dfm_rms )
         DEFT = dfm_rms
         DEF2 = dfm_rms * dfm_rms
*---     Read the L-F deformation coefficients (2nd file)
         open ( 13, FILE = fnm2_dfm, STATUS ='OLD', 
     &              FORM = 'FORMATTED', ERR = 410 )
         CALL REDECO (13, 1, ier)
         close ( 13 )
         IF (ier .NE. 0) GO TO 210
      ENDIF
*---  Build the annular zernike polynomials if appropriate
      if ( (.NOT. LSW0(1)) .AND. (OBSC .GT. 0.D0) ) then
         CALL ZBUILD( NDF, OBSC, IWK1, IWK2, NNDX, NDXARR, COFMAT )
      endif

*---  Initialize the vector quantities
      CALL VINIT

*<=== ------------------------------------------------------------------

*---  normal exit...
      init_surface_intercept = 0
      return

*---  error exits...

210   continue
      write (0, *) 'saodrat: error reading cogen coefficients'
      write (0, *) 'saodrat: IER = ', ier
      STOP 201   ! error stop

400   continue
      write (0, *) 'saodrat: Error opening deform file ', fnm_dfm,
     &                       ' - exiting...'
      init_surface_intercept = 2
      return

410   continue
      write (0, *) 'saodrat: Error opening 2nd deform file ', fnm2_dfm,
     &                       ' - exiting...'
      init_surface_intercept = 2
      return

*---  formats...

600   FORMAT (16A4, 1X, I5)

      END ! init_surface_intercept -------------------------------------
