*+
*KWIC setpar.f
*
*$Id: setpar.f,v 1.2 2004/07/16 20:02:08 dtn Exp $
*
*Revisions:
*   04-Jul-07[D. Nguyen]
*      . setpar.f is basically getparam.f with all the getpar code
*        commented out.  It's main function is to set the parameters
*        (the parameters are accessed from C).
*   96-Jun-03[T. Gaetz]
*      . original version; extracted from initsaodrat
*-
***** file: setpar.f <> $Revision: 1.2 $

*+**********************************************************************
      subroutine setparam( db_extend, srfno_c, input_c, output_c,
     &  fnm_gi_c, fnm_dfm_c, log_file_c, found_dfm_type_c, dfm_type_c,
     &  fnm2_dfm_c, theta0_c, theta02_c, dfm_scale_c, dfm2_scale_c,
     &  do_osac_reflect_c, debug_c )

************************************************************************
*
*kwic getparam --- read parameter file
*
*  arguments:
*
*  comments:
*
*  USER INPUTS :
*
*    96-Jun-03[T. Gaetz]
*       . original version
*
*$Id: setpar.f,v 1.2 2004/07/16 20:02:08 dtn Exp $
*-
      implicit none

*---  named constants...
      INTEGER     LUNERR
      PARAMETER ( LUNERR = 0 )   ! unit number for 'stderr'
      DOUBLE PRECISION DEG2RAD
      PARAMETER      ( DEG2RAD = 1.d0 / 57.295779513082320876798155d0 )

*---  passed variables...
!      CHARACTER*(*) rcsid_string

      INTEGER db_extend  ! debug stuff
      INTEGER srfno_c, found_dfm_type_c, dfm_type_c, do_osac_reflect_c
      CHARACTER*(*) input_c, output_c, fnm_gi_c, fnm_dfm_c, log_file_c
      CHARACTER*(*) fnm2_dfm_c, debug_c
      DOUBLE PRECISION theta0_c, theta02_c, dfm_scale_c, dfm2_scale_c

*---  version info...
!      include 'version.h'

*---  global variables...
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/raystuff.h'
      include 'saosacLib/srfstuff.h'
      include 'saosacLib/gparam.h'

*---  external routines...
      external c_paccess, len_trim, debug_init, dbflag
      integer  c_paccess, len_trim, debug_init, dbflag
 
*---  local variables...

!      character*(3)     srf
!      integer*4         pf   
!      integer           ln
      integer ier                       ! ier 10/29/97
!      logical           version
!      integer           vrsflag
!      LOGICAL           fhelp
      LOGICAL *1        lsw

      LOGICAL *1        LSW0            
      COMMON /SWITCH/   LSW0 (10),  LSW (10, 21)

*CODE getparam -----------------------------------------------------------

*---  READ IN CURRENT surface number, gi filename, deformation filename...
!      call f_prmopn( '$', '$r', pf )
!      vrsflag = c_paccess( pf, 'version' )
!      if ( vrsflag .ne. 0 ) then
!         call f_pgetb( pf, 'version', version )
!         if ( version ) then
!            write ( *, * ) VERSION_STRING
!            stop
!         endif
!      endif

!      call f_pgeti( pf , 'surf_no', srfno)
      KURF = srfno_c

!      in = ' '
!      call f_pgetstr( pf, 'input', in )

      in = input_c

!      out = ' '
!      call f_pgetstr( pf, 'output', out )

      out = output_c

C
C   READ IN gi & FIRST DEFORMATION FILENAMES
C
!      fnm_gi = ' '
!      call f_pgetstr( pf, 'gi_filename', fnm_gi )

      fnm_gi = fnm_gi_c

!      fnm_dfm = ' '
!      call f_pgetstr( pf, 'dfm_filename', fnm_dfm )
      fnm_dfm = fnm_dfm_c

C
C   READ IN NAME OF logfile
C
!      if ( c_paccess(pf, 'logfile') .ne. 0 ) then
!         log_file = ' '
!         call f_pgetstr( pf, 'logfile', log_file )
!      else
!         write( srf, '(i3)' ) kurf
!         if ( 0 .le. kurf  .and.  kurf .le. 9 ) then
!            ln = 3
!         elseif ( 10 .le. kurf  .and.  kurf .le. 99 ) then
!            ln = 2
!         elseif ( 100 .le. kurf  .and.  kurf .le. 999 ) then
!            ln = 1
!         endif
!         log_file = 'surf_' // srf(ln:) // '.lis'
!         ln = len_trim(log_file)
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ', 'WARNING!'
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &      'You are using an old version of the parameter file.'
!         write( LUNERR, '(a,a,a)' )
!     &      'surface_intercept: logfile = ', log_file(:ln),
!     &         ' will be assumed.'
!         write( LUNERR, '(a)' )
!     &      'surface_intercept:  Results will be backwards compatible.'
!         write( LUNERR, '(a)' )
!     &      'surface_intercept:  Please update the parameter file!'
!      endif

      log_file = log_file_c
*   10/31/97: next moved from initsaodrat.f
C*---  open log file...
      open (  8, FILE = log_file )

*===> ------------------------------------------------------------------
*---     (this is what GEOSAC does) **
*        Read the 'gi' file into memory
         open (  9, FILE = fnm_gi,  STATUS ='OLD')
         CALL RDGI( 9, ier )
         close ( 9 )
*
*<=== ------------------------------------------------------------------
C
C        READ VALUE OF DFM_TYPE
C
!      if ( c_paccess(pf, 'dfm_type') .ne. 0 ) then
!         found_dfm_type = .true.
!         call f_pgeti( pf , 'dfm_type', dfm_type )
!      else
!         found_dfm_type = .false.
!         if ( lsw( 10, kurf) ) then
!            dfm_type = 1  ! spline  (switched on 10/29/97)
!         else
!            dfm_type = 0  ! cgn (switched on 10/29/97)
!         endif
!      endif

         if ( found_dfm_type_c .EQ. 1 ) then
            found_dfm_type = .true.
            dfm_type = dfm_type_c
         else
            found_dfm_type = .false.
            if ( lsw( 10, kurf) ) then
               dfm_type = 1     ! spline  (switched on 10/29/97)
            else
               dfm_type = 0     ! cgn (switched on 10/29/97)
            endif
         endif


C
C     IF THERE'S A SECOND DEFORMATION, GET DEFORMATION FILE NAME
C
!         fnm2_dfm = ' '
!      if ( dfm_type .ge. 2 ) then
!         if ( c_paccess(pf, 'dfm2_filename') .ne. 0 ) then
!            call f_pgetstr( pf, 'dfm2_filename', fnm2_dfm )
!         else
!            write( LUNERR, '(a,a)' ) 'surface_intercept: ', 'WARNING!'
!            write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &         'The second deformation file is missing!!!'
!         endif
!      endif

         if ( dfm_type .ge. 2 ) then
            fnm2_dfm = fnm2_dfm_c
         endif

C
C   READ IN FIRST theta0
C
!      if ( c_paccess(pf, 'theta0') .ne. 0 ) then
!         call f_pgetd( pf, 'theta0', theta0 )
!         theta0    = theta0 * deg2rad
!         costheta0 = cos(theta0)
!         sintheta0 = sin(theta0)
!      else
!         theta0    = 0.d0
!         costheta0 = cos(theta0)
!         sintheta0 = sin(theta0)
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ', 'WARNING!'
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &      'You are using an old version of the parameter file.'
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &      '''theta0 = 0.d0'' will be assumed.'
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &      'Results will be backwards compatible.'
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &      'Please update the parameter file!'
!      endif

         theta0 = theta0_c
         costheta0 = cos(theta0)
         sintheta0 = sin(theta0)

!dbg     write( LUNERR, '(a,i5,1p,3e15.7)' ) 'surface_intercept: clock ', 
!dbg &   srfno, theta0/deg2rad, costheta0, sintheta0
C
C     CALL FOR SECOND THETA (theta02) IF DFM_TYPE >=2
C
!      if ( dfm_type .ge. 2 ) then
!         if ( c_paccess(pf, 'theta02') .ne. 0 ) then
!            call f_pgetd( pf, 'theta02', theta02 )
!            theta02    = theta02 * deg2rad
!            costheta02 = cos(theta02)
!            sintheta02 = sin(theta02)
!        else
!            theta02    = 0.d0
!            costheta02 = cos(theta02)
!            sintheta02 = sin(theta02)
!            write( LUNERR, '(a,a)' ) 'surface_intercept: ', 'WARNING!'
!            write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &         'You are using an old version of the parameter file.'
!            write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &         '''theta02 = 0.d0'' will be assumed.'
!            write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &         'Results will be backwards compatible.'
!            write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &         'Please update the parameter file!'
!         endif
!       endif

         theta02 = theta02_c
         costheta02 = cos(theta02)
         sintheta02 = sin(theta02)

!dbg     write( LUNERR, '(a,i5,1p,3e15.7)' ) 'surface_intercept: clock ', 
!dbg &      srfno, theta02/deg2rad, costheta02, sintheta02
C
C   READ IN FIRST scaling parameter
C
!      if ( c_paccess(pf, 'dfm_scale') .ne. 0 ) then
!         call f_pgetd( pf, 'dfm_scale', dfm_scale )
!      else
!         dfm_scale = 1.d0
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ', 'WARNING!'
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &      'You are using an old version of the parameter file.'
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &      '''dfm_scale = 1.d0'' will be assumed.'
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &      'Results will be backwards compatible.'
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &      'Please update the parameter file!'
!      endif

         dfm_scale = dfm_scale_c

!dbg     write( LUNERR, '(a,i5,1p,3e15.7)' ) 'surface_intercept: dfm_scale ', 
!dbg &   srfno, dfm_scale
C
C    CALL FOR SECOND scaling parameter (dfm2_scale) IF DFM_TYPE>=2
C
!      if ( dfm_type .ge. 2 ) then
!         if ( c_paccess(pf, 'dfm2_scale') .ne. 0 ) then
!            call f_pgetd( pf, 'dfm2_scale', dfm2_scale )
!         else
!            dfm2_scale = 1.d0
!            write( LUNERR, '(a,a)' ) 'surface_intercept: ', 'WARNING!'
!            write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &         'You are using an old version of the parameter file.'
!            write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &         '''dfm2_scale = 1.d0'' will be assumed.'
!            write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &         'Results will be backwards compatible.'
!            write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &         'Please update the parameter file!'
!         endif
!dbg     write( LUNERR, '(a,i5,1p,3e15.7)' ) 'surface_intercept: dfm2_scale ', 
!dbg &      srfno, dfm2_scale
!      endif

         dfm2_scale = dfm2_scale_c

C
C     call for Boolean flag for deformation
C
!      if ( c_paccess(pf, 'dfm_binary_io') .ne. 0 ) then
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ', 'WARNING!'
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &      'You are using an old version of the parameter file.'
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &      'dfm_binary_io is no longer required.XS'
!      endif

!      if ( c_paccess(pf, 'do_osac_reflect') .ne. 0 ) then
!         call f_pgetb( pf, 'do_osac_reflect', do_osac_reflect )
!      else
!         do_osac_reflect = .true.
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ', 'WARNING!'
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &      'You are using an old version of the parameter file.'
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &      '''do_osac_reflect = .TRUE.'' will be assumed.'
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &      'surface_intercept ***WILL*** reflect the rays'
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &      'Results will be backwards compatible.'
!         write( LUNERR, '(a,a)' ) 'surface_intercept: ',
!     &      'Please update the parameter file!'
!      endif

      if ( do_osac_reflect_c .eq. 1 ) then
         do_osac_reflect = .true.
      else
         do_osac_reflect = .false.
      endif

!      if ( c_paccess(pf, 'help') .ne. 0 ) then
!         call f_pgetb( pf, 'help', fhelp )
!         if ( fhelp ) then
!            call fusage
!            stop
!         end if
!      end if

!      if ( c_paccess(pf, 'onlygoodrays') .ne. 0 ) then
!         call f_pgetb( pf, 'onlygoodrays', fgoodrays )
!      else
!         fgoodrays = .true.
!      end if

      debug = debug_c

C     determine if data fields are to be extended
!      db_extend = 0
!      call f_pgetstr( pf, 'debug', debug )
!      debugstring = debug_init( debug )
!      db_extend =  dbflag('extend_all')
!      call f_prmcls ( pf )


      END ! getparam -----------------------------------------------------












