#============================================================================
# prog_usage_c_base.mk

PROG_USAGE_C_BASE_MK =

# the caller must set POD_SRC to the name of the pod source file
# e.g.:

#  POD_SRC = $(top_srcdir)/docs/$(PACKAGE_NAME).pod 
#  POD_SRC = $(srcdir)/bin.pod 

POD_SRC +=

# if POD_SRC is found via VPATH, then the command may not have
# the correct path to it, depending upon the make (Solaris make will
# rewrite the command, GNU make won't).  To catch this error early,
# explicitly check for the existence of it.
usage.c : $(POD_SRC)
	test -f $? || { echo "Bad VPATH in Makefile"; false; }
	pod2text < $? | text2usage -pfx usage

MAINTAINERCLEANFILES	+= usage.c usage.h
EXTRA_DIST		+= usage.c usage.h
BUILT_SOURCES		+= usage.c
