/* --8<--8<--8<--8<--
 *
 * Copyright (C) 2006 Smithsonian Astrophysical Observatory
 *
 * This file is part of src
 *
 * src is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * src is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 *       Free Software Foundation, Inc. 
 *       51 Franklin Street, Fifth Floor
 *       Boston, MA  02110-1301, USA
 *
 * -->8-->8-->8-->8-- */

#ifndef INIT_H

#define INIT_H

#ifdef __cplusplus
extern "C" {
#endif

#include "mst_fortran_charlen_t.h"

 /* init.f */
#define INITCONST_F77 F77_FUNC(initconst,INITCONST)
void INITCONST_F77( int* srfno, int* lsw0_srfno );

#define FLUSHCLOSE8_F77 F77_FUNC(flushclose8,FLUSHCLOSE8)
void FLUSHCLOSE8_F77( void );

/* ./init_surface_intercept.f */
#define INIT_SURFACE_INTERCEPT_F77 F77_FUNC_(init_surface_intercept,INIT_SURFACE_INTERCEPT)
int INIT_SURFACE_INTERCEPT_F77( void );

/* ./getpram.f */
#define SETPARAM_F77 F77_FUNC(setparam,SETPARAM)
void SETPARAM_F77( int* db_extend, int* srfno, char* input, char* output,
		   char* fnm_gi, char* fnm_dfm, char* log_file,
		   int* found_dfm_type, int* dfm_type, char* fnm2_dfm,
		   double* theta0, double* theta02, double* dfm_scale,
		   double* dfm2_scale, int* do_osac_reflect, char* debug,
		   mst_fortran_charlen_t input_strlen, mst_fortran_charlen_t output_strlen,
                   mst_fortran_charlen_t fnm_gi_strlen, mst_fortran_charlen_t fnm_dfm_strlen,
                   mst_fortran_charlen_t log_file_strlen, mst_fortran_charlen_t fnm2_dfm_strlen,
                   mst_fortran_charlen_t debug_strlen );

#ifdef __cplusplus
}
#endif

#endif /* ! INIT_H */
