##							-*- Autoconf -*-

# serial 1

# MST_CHECK
#----------
# Check dependencies, recording failure status and report
# failure for all checks at end of list so that user
# sees them all
# 1. MST_CHECK_SETUP
# 2. MST_CHECK_XXX as needed
# 3. MST_CHECK_STATUS to report on the final status of the test
#    and die if necessary

# MST_CHECK_SETUP
#------------------
# Perform setup steps for dependencies.
AC_DEFUN([MST_CHECK_SETUP],
[
 MST_CHECKS_OK=
])# MST_CHECK_SETUP


# MST_CHECK_TEST(command, message)
#-----------------------------------
# Run the command.  If it returns false, report that the dependency
# has failed and update the global dependency state.
AC_DEFUN([MST_CHECK_TEST],
[AC_REQUIRE([MST_CHECK_SETUP])
 mst_check_test=
 AS_IF([$1],[mst_check_test=yes],[mst_check_test=no])
 MST_CHECK_FLAG([$mst_check_test],
                ,
		[AC_MSG_WARN([$2: Missing dependency])]
		)
])# MST_CHECK_TEST

# MST_CHECK_FLAG(result,[ACTION-IF-TRUE],[ACTION-IF-FALSE])
#------------------------------------------------------------
# update the status flag based upon a test result
AC_DEFUN([MST_CHECK_FLAG],
[AC_REQUIRE([MST_CHECK_SETUP])

 AS_IF( [test "x$1" = "xno"],
        [ MST_CHECKS_OK=no
	  $3
	],
	[ AS_IF([test ! "x$MST_CHECKS_OK" = "xno"],[MST_CHECKS_OK=yes])
	  $2
	]
      )
])# MST_CHECK_FLAG

# MST_CHECK_PROG(program)
#-----------------------------------
# check if the program exists
AC_DEFUN([MST_CHECK_PROG],
[AC_REQUIRE([MST_CHECK_SETUP])
 mst_check_prog=no

 m4_define(mst_check_prog,m4_normalize([$1]))
 AS_VAR_PUSHDEF(mst_check_prog_var,mst_check_prog_var_[]mst_check_prog)
 AC_CHECK_PROG(mst_check_prog_var,mst_check_prog,[yes],[no])
 MST_CHECK_FLAG($mst_check_prog_var)
 m4_undefine([mst_check_prog_var])
 m4_undefine([mst_check_prog])

])# MST_CHECK_PROG

# MST_CHECK_PKG_MODULES(VARIABLE-PREFIX, MODULES)
#-----------------------------------
# check if the modules exist. uses pkg-config's PKG_CHECK_MODULES to
# see if the modules exist, but instead of aborting on error, sets the
# MST_CHECK flag appropriately
AC_DEFUN([MST_CHECK_PKG_MODULES],
[PKG_CHECK_MODULES([$1],[$2],
	[MST_CHECK_FLAG([yes])],
	[MST_CHECK_FLAG([no])])
])# MST_CHECK_PKG_MODULES


# MST_CHECK_STATUS
#-------------------
# If any test dependencies have failed, report that.  Exit with error
# unless --disable-testdeps was passed to configure.
# Creates and automake conditional HAVE_CHECKS which reflects the
# state of test dependencies
AC_DEFUN([MST_CHECK_STATUS],
[AC_REQUIRE([MST_CHECK_SETUP])

 AS_IF( [test "x$MST_CHECKS_OK" = "xno"],
        [AC_MSG_ERROR([Missing dependencies. Cannot proceed.] ) ]
      )
])# MST_CHECK_STATUS
