.\" -*- mode: troff; coding: utf-8 -*-
.\" Automatically generated by Pod::Man 5.01 (Pod::Simple 3.43)
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" \*(C` and \*(C' are quotes in nroff, nothing in troff, for use with C<>.
.ie n \{\
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds C`
.    ds C'
'br\}
.\"
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\"
.\" If the F register is >0, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.SS), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.\"
.\" Avoid warning from groff about undefined register 'F'.
.de IX
..
.nr rF 0
.if \n(.g .if rF .nr rF 1
.if (\n(rF:(\n(.g==0)) \{\
.    if \nF \{\
.        de IX
.        tm Index:\\$1\t\\n%\t"\\$2"
..
.        if !\nF==2 \{\
.            nr % 0
.            nr F 2
.        \}
.    \}
.\}
.rr rF
.\" ========================================================================
.\"
.IX Title "trace-nest l"
.TH trace-nest l 2025-11-19 " " " "
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.if n .ad l
.nh
.SH NAME
trace\-nest \- ray trace a nest of shells, hey!
.SH SYNOPSIS
.IX Header "SYNOPSIS"
\&\fBtrace-nest\fR \fIoptions\fR
.SH ARGUMENTS
.IX Header "ARGUMENTS"
\&\fBtrace-nest\fR uses an IRAF-compatible parameter interface. See the
section on "Setup" below.  The available parameters are:
.IP \fBtag\fR 8
.IX Item "tag"
A prefix to be used on all intermediate files created.  There are lots
of intermediate files; see the section on "Intermediate Files".
.IP \fBsrc\fR 8
.IX Item "src"
The location of a \fBraygen\fR compatible source script.  If it is the
string \f(CW\*(C`default\*(C'\fR, the value of the \f(CW\*(C`source_spec\*(C'\fR keyword in the
\&\fBtrace-nest\fR configuration file is used.
.IP \fBsrcpars\fR 8
.IX Item "srcpars"
Extra parameters to be passed to the source script.  See the
documentation for the source script for information on which
parameters are available.  script accepts
.Sp
These are passed directly to \fBraygen\fR via the \f(CW\*(C`source_override\*(C'\fR
parameter.
.IP \fBshells\fR 8
.IX Item "shells"
The shells that should be raytraced and merged.  The value may be take
one of the following values:
.RS 8
.ie n .IP """all""" 4
.el .IP \f(CWall\fR 4
.IX Item "all"
All of the shells defined in the mirror geometry database will be
raytraced.
.ie n .IP """active""" 4
.el .IP \f(CWactive\fR 4
.IX Item "active"
All of the shells defined in the mirror geometry database which are
marked as \f(CW\*(C`active\*(C'\fR will be raytraced.  If the geometry database does not
provide the \f(CW\*(C`active\*(C'\fR attribute, all of the shells are raytraced.
.IP \fIlist\fR 4
.IX Item "list"
A comma delimited list of individual shell ids or ranges
(\fImin\fR\-\fImax\fR).  For example:
.Sp
.Vb 1
\&  shells=1\-10,23,45
.Ve
.RE
.RS 8
.RE
.IP \fBoutput\fR 8
.IX Item "output"
The output stream to which to write the rays.  It may be a filename,
or the string \f(CW\*(C`stdout\*(C'\fR, in which case rays will be written to the
standard output stream.  If it is the string \f(CW\*(C`default\*(C'\fR, a file name
will be created by appending the \fBoutput_fmt\fR to the \fBtag\fR (with an
intervening period).
.IP \fBoutput_fmt\fR 8
.IX Item "output_fmt"
The output format of the rays.  May be one of \f(CW\*(C`fr\*(C'\fR, \f(CW\*(C`bp\*(C'\fR, \f(CW\*(C`bpipe\*(C'\fR, \f(CW\*(C`rdb\*(C'\fR,
or a \f(CW\*(C`fits\*(C'\fR variant.  See "Output Formats" for more information.
.IP \fBoutput_coord\fR 8
.IX Item "output_coord"
The output coordinate system of the rays.  May be one of \f(CW\*(C`osac\*(C'\fR,
\&\f(CW\*(C`hrma\*(C'\fR, \f(CW\*(C`xrcf\*(C'\fR.
.IP \fBoutput_fields\fR 8
.IX Item "output_fields"
Which data fields to output for each ray.  The value may be one of
.RS 8
.ie n .IP """all""" 4
.el .IP \f(CWall\fR 4
.IX Item "all"
A rather large amount of information.
.IP "<field names>" 4
.IX Item "<field names>"
A comma delimited list of field names to output.  Field names may be
prefixed with \f(CW\*(C`\-\*(C'\fR, indicating that they are to be \fIremoved\fR from the
list of output fields.  If the only fields specified are those to be
removed, the initial output list contains all of the fields in the data.
.Sp
The field name \f(CW\*(C`min\*(C'\fR is an alias for specifying the following fields:
.Sp
.Vb 1
\&  position direction weight energy time
.Ve
.Sp
The order of additive and subtractive fields is unimportant; all additive
fields are inserted into the list before the subtractive fields are removed.
.RE
.RS 8
.RE
.IP \fBseed1\fR 8
.IX Item "seed1"
The first seed for the random number generator.  It must be in the range
[1,2147483562].
.IP \fBseed2\fR 8
.IX Item "seed2"
The second seed for the random number generator.  It must be in the range
[1,214748339]
.IP \fBblock\fR 8
.IX Item "block"
The random number block to start at.  It must be in the range [0,1048575].
.IP \fBblock_inc\fR 8
.IX Item "block_inc"
The spacing between random number blocks for each random process.  100
is a good number.
.IP \fBtstart\fR 8
.IX Item "tstart"
The start time of the observation in seconds.  If less than zero and
jitter is turned on, the start of the valid jitter time range is used.
.IP \fBlimit\fR 8
.IX Item "limit"
The numerical value of the limit at which to stop generating rays at
the telescope entrance aperture. The number of rays which reach the
focal plane are typically lower than this.  The \fBlimit_type\fR
parameter specifies the units for this value.
.Sp
\&\fBlimit\fR may be either a floating point number, in which it is used for
all shells, or the name of a file containing \fIlimit\fR values for all
shells.  The file must be an \fBRDB\fR formatted file with columns
\&\fIshell\fR and \fIlimit\fR.
.Sp
If \f(CW\*(C`limit_type\*(C'\fR is a unit of time, this is added to the
start time (see \f(CW\*(C`tstart\*(C'\fR) to determine the stop time of the
simulation. If jitter is on and this is set to \f(CW0\fR, then the stop
time is set equal to the end of the valid jitter time range.
.IP \fBlimit_type\fR 8
.IX Item "limit_type"
The units of the limit at which to stop generating rays.
.RS 8
.ie n .IP """ksec""" 8
.el .IP \f(CWksec\fR 8
.IX Item "ksec"
kiloseconds of observation time
.ie n .IP """sec""" 8
.el .IP \f(CWsec\fR 8
.IX Item "sec"
seconds of observation time
.ie n .IP """r/mm2""" 8
.el .IP \f(CWr/mm2\fR 8
.IX Item "r/mm2"
a ray density at the entrance aperture in rays / mm^2
.ie n .IP """r/cm2""" 8
.el .IP \f(CWr/cm2\fR 8
.IX Item "r/cm2"
a ray density at the entrance aperture in rays / cm^2
.RE
.RS 8
.RE
.IP \fBray_dist\fR 8
.IX Item "ray_dist"
The ray distribution at the entrance aperture.  It may be one of \f(CW\*(C`random\*(C'\fR or
\&\f(CW\*(C`ringspoke\*(C'\fR.  \fICurrently,\fR \f(CW\*(C`ringspoke\*(C'\fR \fIis ignored.\fR
.IP \fBnrings\fR 8
.IX Item "nrings"
The number of rings to use if the \fBray_dist\fR parameter is \f(CW\*(C`ringspoke\*(C'\fR.
.IP \fBnspokes\fR 8
.IX Item "nspokes"
The number of spokes to use if the \fBray_dist\fR parameter is \f(CW\*(C`ringspoke\*(C'\fR.
.IP \fBfocus\fR 8
.IX Item "focus"
A boolean parameter indicating that the focus of the system is to be
determined.  See the "Focus" section for more details.
.IP \fBz\fR 8
.IX Item "z"
The position along the \fIZ\fR (optical) axis at which to leave the rays.
This is in the OSAC coordinate system.
.Sp
\&\fBz\fR may be either a floating point number, in which it is used for
all shells, or the name of a file containing \fIZ\fR values for all
shells.  The file must be an \fBRDB\fR formatted file with columns
\&\fIshell\fR and \fIz\fR.  The \fIZ\fR value for the combined shells should have
a \fIshell\fR value of \f(CW99999\fR.
.IP \fBtally\fR 8
.IX Item "tally"
If non-zero, a tally of rays will be written to the standard
error stream every \f(CW\*(C`tally\*(C'\fR rays.  This is useful if you're wondering
why it's taking so long to run the raytrace.  This tallies the number
of rays which make it out of the nest, after all of the post-optic
apertures.
.IP \fBthrottle\fR 8
.IX Item "throttle"
If non-zero, this specifies the number of rays which should be
output after the shells are merged.  Rays are first eliminated
based upon their probability of reflection, and then only the
requested number are passed through through (provided enough are
available).  The number may be varied in a Poisson fashion by setting
\&\fBthrottle_poisson\fR.
.Sp
If negative, rays will be eliminated by their probability of
reflection, but no total limit to their number will be set.
.Sp
A side effect of this option is that all rays will have a weight of one.
.IP \fBthrottle_poisson\fR 8
.IX Item "throttle_poisson"
If true, and if \fBthrottle\fR is non-zero, then the number specified by
\&\fBthrottle\fR is treated as the mean of a Poisson distribution, and the
number of rays actually output will be drawn from that distribution.
.IP \fBclean\fR 8
.IX Item "clean"
Which intermediate files to delete.  It may be \f(CW\*(C`none\*(C'\fR, in which case
nothing is removed, \f(CW\*(C`rays\*(C'\fR in which case intermediate ray files are
removed, or \f(CW\*(C`all\*(C'\fR in which everything is removed.
.IP \fBconfig_dir\fR 8
.IX Item "config_dir"
The directory containing the \fBtrace-nest\fR configuration file.
.IP \fBconfig_db\fR 8
.IX Item "config_db"
The name of the configuration file which provides the details of the
HRMA configuration.  See the "Configuration File" section below.
.IP \fBversion\fR 8
.IX Item "version"
Print out the version information and exit.
.IP \fBhelp\fR 8
.IX Item "help"
Print out this message and exit.
.IP \fBdebug\fR 8
.IX Item "debug"
A comma separated list of debugging options.  See the "Debugging"
section for more information.
.SH DESCRIPTION
.IX Header "DESCRIPTION"
\&\fBtrace-nest\fR raytraces a nest of Wolter type I X\-ray telescope
shells with various apertures and baffles.  It was designed around the
AXAF HRMA, but may be used for other systems.  It works by using
\&\fBtrace-shell\fR to raytrace each shell, finally merging them into a
single file.  It traces each shell sequentially, storing each shells'
rays on disk; it ends up using twice as much disk space as you think.
It'll clean up after itself, though (see the \fBclean\fR parameter).
.PP
\&\fBtrace-nest\fR uses a variety of programs to accomplish the raytrace.
To see the actual raytrace command pipeline, use the \fBdebug\fR \f(CW\*(C`pcomm\*(C'\fR
option.
.SS Setup
.IX Subsection "Setup"
\&\fBtrace-nest\fR uses an IRAF compatible parameter interface.  Because
it calls many other programs, you will actually need to have parameter
files for all of them handy.
.PP
To simplify things, there is a command (\fBtrace\-nest_setup\fR) which
creates copies in the current directory of the all of the required
parameter files.
.SS "Configuration File"
.IX Subsection "Configuration File"
The \fBtrace-nest\fR configuration file (specified by the \fBconfig_dir\fR
and \fBconfig_db\fR parameters) describes the telescope
configuration. Before you create your own, look at
\&\fI/proj/axaf/simul/databases/ts_config/00Index.html\fR and see if
there's one to suit your fancy.  Also, note that \fBtrace-nest\fR can
only use configuration files with a \f(CW\*(C`.cnf\*(C'\fR suffix.  For more
information on raytrace configuration files, etc. see ts_config.
.SS "Intermediate Files"
.IX Subsection "Intermediate Files"
\&\fBtrace-nest\fR produces a few intermediate files. Each file is given a
prefix which consists of the value of the \fBtag\fR parameter followed
the shell number.  For the final set of merged rays, the shell number
is left off. For example, if \fBtag\fR is \f(CW\*(C`foo\*(C'\fR, you'll get files of
.PP
.Vb 1
\&        foo_1.tot_wt.in.log foo_2.tot_wt.in.log
.Ve
.PP
and
.PP
.Vb 1
\&        foo.tot_wt.in.log
.Ve
.PP
If \fBtrace-nest\fR is only tracing one shell, it doesn't include the shell
number in the file name.
.IP \fBtag.bp\fR 8
.IX Item "tag.bp"
The rays for the particular shell, in \fBbpipe\fR format.
.IP \fBtag.gi\fR 8
.IX Item "tag.gi"
This is a rather arcanely formatted file required by \fBSAOdrat\fR.  It's
not of much general interest.
.IP \fBtag.tot\-wt.in.log\fR 8
.IX Item "tag.tot-wt.in.log"
This file contains the number and weight of the rays at the entrance
aperture.  It is produced by \fBtot_wt\fR.
.IP \fBtag.tot_wt.out.log\fR 8
.IX Item "tag.tot_wt.out.log"
This file contains the number and weight of the rays which have made
it through the entire configuration.  It is produced by \fBtot_wt\fR.
.IP \fBtag.tot_wt.throttle.log\fR 8
.IX Item "tag.tot_wt.throttle.log"
This file contains the number and weight of the rays which have made
it through the entire configuration, after getting throttled.  It is
produced by \fBtot_wt\fR.
.IP \fBtag.focus.log\fR 8
.IX Item "tag.focus.log"
This is created during a focus run by \fBsaofocus\fR.
.SS "Output Formats"
.IX Subsection "Output Formats"
\&\fBtrace-nest\fR outputs one of the following formats, specified by the
\&\fBoutput_fmt\fR parameter:
.ie n .IP """fr""" 8
.el .IP \f(CWfr\fR 8
.IX Item "fr"
The \f(CW\*(C`fr\*(C'\fR format has no header.  Each ray is in a \f(CW\*(C`fullray\*(C'\fR
structure.  See \fI/proj/axaf/simul/include/fullray.h\fR for the formats
of the ray structure.
.ie n .IP """bp"" or ""bpipe""" 8
.el .IP "\f(CWbp\fR or \f(CWbpipe\fR" 8
.IX Item "bp or bpipe"
The rays are in \f(CW\*(C`bpipe\*(C'\fR format. See the \fBbpipe\fR documentation for
more information on this.
.ie n .IP """rdb""" 8
.el .IP \f(CWrdb\fR 8
.IX Item "rdb"
The rays are written as an RDB table.
.ie n .IP "a ""fits"" variant" 8
.el .IP "a \f(CWfits\fR variant" 8
.IX Item "a fits variant"
Various FITS formatted outputs may be specified.  In all cases the
output must be to a file.
.RS 8
.ie n .IP """fits"" or ""fits\-std""" 4
.el .IP "\f(CWfits\fR or \f(CWfits\-std\fR" 4
.IX Item "fits or fits-std"
The rays are written in the uncommon and seldom used AXAF Photon FITS
standard.
.ie n .IP """fits\-events""" 4
.el .IP \f(CWfits\-events\fR 4
.IX Item "fits-events"
The rays are written in the much more common "events" format.  It
differs from the AXAF FITS Photon Standard in that the binary table is
named \f(CW\*(C`EVENTS\*(C'\fR, the \f(CW\*(C`rt_\*(C'\fR prefix is removed from the column names,
and the energy column is named \f(CW\*(C`energy\*(C'\fR and is in units of eV.  Most
X\-ray Astronomy software uses this convention.
.RE
.RS 8
.RE
.SS Focus
.IX Subsection "Focus"
If you wish to determine where the focal point for a given
configuration is, set the \fBfocus\fR parameter to \f(CW\*(C`yes\*(C'\fR.  However,
because of bad interactions between the focus algorithm and wildly
scattered rays, micro-roughness induced ray scattering and ghost-ray
tracking is turned off when focussing. Additionally, the source is
forced to be the default source specified by the configuration file,
which should be a point source. The default source requires at least
one parameter, namely \f(CW\*(C`energy\*(C'\fR. The focus procedure is carried out by
\&\fBsaofocus\fR which leaves its results in a file called
\&\f(CW\*(C`tag.focus.lis\*(C'\fR, (where you've specified \fBtag\fR).  This file is
pretty arcane; generally to extract the focus from there, run the
script \fIgetfocus\fR on it:
.PP
.Vb 1
\&  getfocus tag.focus.lis
.Ve
.PP
which will write out the focal position (in OSAC coordinates) to the
UNIX standard output stream.  Note that you'll get the focus of all of
the individual shells as well as the nest (unless you set \fBclean\fR to
\&\f(CW\*(C`all\*(C'\fR).
.PP
All of the shells' focal distances, including the focal distance
for the combined shells, is written to the file \f(CW\*(C`tag.focus.rdb\*(C'\fR.
The combined shells are assigned a shell number of \f(CW99999\fR.
.SS Debugging
.IX Subsection "Debugging"
There are several \fBdebug\fR options available:
.ie n .IP """pcomm""" 8
.el .IP \f(CWpcomm\fR 8
.IX Item "pcomm"
Print out the raytrace command before executing it.  This gives you
some idea of which programs are running and what their inputs are.
.ie n .IP """noexec""" 8
.el .IP \f(CWnoexec\fR 8
.IX Item "noexec"
Generate the raytrace command and any required intermediate files, but
do not execute it.  Most useful with the \fBpcomm\fR \fBdebug\fR option.
.ie n .IP """reuse""" 8
.el .IP \f(CWreuse\fR 8
.IX Item "reuse"
Reuse the raytrace output from a previous \fBidentical\fR run to
regenerate the summary information.  \f(CW\*(C`noexec\*(C'\fR must \fInot\fR be
specified simultaneously.  The raytrace parameters should be
identical except for the addition of this flag.
.ie n .IP """noproject""" 8
.el .IP \f(CWnoproject\fR 8
.IX Item "noproject"
Do not project the rays to the value specified by the \fBz\fR parameter.
This is a temporary kludge, and will probably not survive into the
next version of \fBtrace-nest\fR.
.ie n .IP """noghosts""" 8
.el .IP \f(CWnoghosts\fR 8
.IX Item "noghosts"
Ghost rays will not be propagated through the system.
.ie n .IP """saveblock""" 8
.el .IP \f(CWsaveblock\fR 8
.IX Item "saveblock"
The next unused random number block is written to \fItag.block\fR.
.SH "SEE ALSO"
.IX Header "SEE ALSO"
\&\fBtrace-shell\fR, \fBts_config\fR
.SH "COPYRIGHT AND LICENSE"
.IX Header "COPYRIGHT AND LICENSE"
This software is Copyright The Smithsonian Astrophysical Observatory
and is released under the GNU General Public License.  You may find a
copy at: <http://www.fsf.org/copyleft/gpl.html>
.SH Author
.IX Header "Author"
Diab Jerius ( djerius@cfa.harvard.edu )
