#! /usr/bin/env perl

use 5.012;

use Test2::V0;
use Test::TempDir::Tiny;

use Readonly;
use Capture::Tiny qw( capture );

use CIAO::Lib::Param;
use My::Test::Param;
use My::Test::Util;
use YAML;

use File::Spec::Functions qw( catfile catdir );

use constant EXE => catfile( BUILDDIR, 'src', 'trace-shell' );

{
    my $label = 'orbit-200809-01f-a';
    subtest $label => sub {

        in_tempdir $label => sub {
            my $dir = shift;

          SKIP: {

                {
                    my ( $stdout, $stderr, $exit ) = capture {
                        my @cmd = ( EXE, "tag=tag", "config_db=$label", "output_fmt=rdb" );
                        system { $cmd[0] } @cmd;
                    };

                    is( $exit, 0, "run raytrace" )
                      or do {
                        diag $stderr;
                        diag "see results in $dir";
                        skip "can't continue test";
                      };
                }

                {
                    my ( $stdout, $stderr, $exit ) = capture {
                        system {'rdbstats'}
                          'rdbstats',
                          ( -i => "tag.rdb" ),
                          ( -o => "tag.stats.rdb" ),
                          ( '--exclude-re' => '^polarization' )
                          ;
                    };

                    is( $exit, 0, "rdbstats" )
                      or do {
                        diag $stderr;
                        diag "see results in $dir";
                        skip "can't continue test";
                      };
                }

                for my $file ( qw[
                    tag.aperture.cap.log
                    tag.aperture.cap.lua
                    tag.aperture.postcollimator.log
                    tag.aperture.postcollimator.lua
                    tag.aperture.precollimator.log
                    tag.aperture.precollimator.lua
                    tag.block
                    tag.gi
                    tag.intercept.h.log
                    tag.intercept.p.log
                    tag.raygen.cfgpars.lua
                    tag.raygen.srcpars.lua
                    tag.reflect.h.log
                    tag.reflect.p.log
                    tag.scatter.h.log
                    tag.scatter.p.log
                    tag.stats.rdb
                    tag.summary.yml
                    tag.tot_wt.in.log
                    tag.tot_wt.out.log
                    ] )
                {
                    my ( $got, $expected ) = do {
                        my @exp_path = ( 'run', $label, $file );

                        if ( $file =~ /.yml/ ) {
                            (
                                YAML::LoadFile( $file ),
                                load_exp_yaml( @exp_path ),
                              )
                        }

                        elsif ( $file =~ /.gi/ ) {
                            (
                             load_gi( $file ),
                             load_exp_gi( @exp_path ),
                            )
                        }

                        elsif ( $file =~ /.rdb/ ) {
                            (
                             load_rdb( $file ),
                             load_exp_rdb( @exp_path ),
                            )
                        }

                        else {
                            (
                                [ read_lines( $file ) ],
                                read_exp_lines( @exp_path ),
                            );
                        }
                    };

                    is( $got, $expected, $file )
                      or diag "see results in $dir";
                }
            }
          }
    };
}

done_testing;
