AddPathUnique()         #  Add $2 to path variable named by $1, uniquely        
{
  #Remove $2 from $1 
  _tmp=`eval echo '$'${1}`
  _tmp=`echo $_tmp | sed "s%$2%%g" | sed "s%::%:%g"`
  if [ "x${_tmp}" != "x" ] ; then
    if [ "${_tmp:0:1}" != ":" ] ; then
      eval "${1}"="${2}:${_tmp}"
    else
      #If $2 was the first part of $1, there will be an extra leading colon
      eval "${1}"="${2}${_tmp}"
    fi
  else
    eval "${1}"="${2}"
  fi
  export ${1}
  unset _tmp
}

if [ "x${IPYTHONDIR}" = "x" ] ; then
  export IPYTHONDIR="${HOME}/.ipython-ciao" #Default
fi

export ASCDS_INSTALL=$CONDA_PREFIX
export OBSVIS_PKG_PATH=$ASCDS_INSTALL/lib/tcltk/packages/obsvis
export ASCDS_CALIB=$ASCDS_INSTALL/data
if [ "x${ASCDS_WORK_PATH}" != "x" ] ; then
  ASCDS_DUMMY="x"
else
  if [ "x${TMPDIR}" != "x" ] ; then
    if [ -d $TMPDIR ] ; then
      ASCDS_WORK_PATH="${TMPDIR}"
    else
      echo "WARNING: TMPDIR is set to '${TMPDIR}' but is not a directory, setting ASCDS_WORK_PATH to /tmp instead"
      ASCDS_WORK_PATH="/tmp"
    fi
  else
    ASCDS_WORK_PATH="/tmp"
  fi
  export ASCDS_WORK_PATH
fi
if [ "x${ASCDS_TMP}" != "x" ] ; then
  ASCDS_DUMMY="x"
else
  if [ "x${TMPDIR}" != "x" ] ; then
    if [ -d $TMPDIR ] ; then
      ASCDS_TMP="${TMPDIR}"
    else
      echo "WARNING: TMPDIR is set to '${TMPDIR}' but is not a directory, setting ASCDS_TMP to /tmp instead"
      ASCDS_TMP="/tmp"
    fi
  else            
    ASCDS_TMP="/tmp"
  fi
  export ASCDS_TMP
fi

#Set XPA_METHOD to local to avoid issues if not network connection
export XPA_METHOD="local"

#PFILES
SYSPFILES="$ASCDS_INSTALL/param"
if [ "x$LOCPFILES" = "x" ] ; then
  export LOCPFILES="$HOME/cxcds_param4"  #Defaults to $HOME/cxcds_param4
fi
if [ "$PFILES" != "" ] ; then
  #If PFILES is already set, get the system and local paths
  _delimExists=`echo $PFILES | grep ';'`
  if [ "$_delimExists" != "" ]; then
    syspf=`echo $PFILES | sed "s%.*;%%"`
    locpf=`echo $PFILES | sed "s%;*$syspf$%%"`
  else
    locpf=$PFILES
  fi
  unset _delimExists
  AddPathUnique syspf $SYSPFILES
  AddPathUnique locpf $LOCPFILES
else
  #Otherwise set PFILES to default
  syspf="${SYSPFILES}"
  locpf="${LOCPFILES}"
fi
export PFILES="${locpf};${syspf}"

_tmp=`echo "$LOCPFILES" | sed "s%:% %g"`
for _dir in `echo "$_tmp"`
do
   if [ ! -d "$_dir" ] ; then
      mkdir $_dir     # if local param dir does exist, create it
   fi
done

#Set ASCDS_* environment variables
export ASCDS_BIN="$ASCDS_INSTALL/bin"
export ASCDS_LIB="$ASCDS_INSTALL/lib"
export ASCDS_OTS="$ASCDS_INSTALL"
export ASCDS_PROP_DATE_DATA="$ASCDS_INSTALL/config/jcm_data"
export ASCDS_PROP_PREC_DATA="$ASCDS_INSTALL/config/jcm_data"
export ASCDS_SYS_PARAM="$syspf"


#Cleanup, but leave LOCPFILES as a system default
unset SYSPFILES locpf syspf _tmp _dir ASCDS_DUMMY
