############################################################################
# 
#  Copyright (C) 2008-2012,2014-2015,2020,2023  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

#
# FILE NAME: ciao_setup.csh.in
#
# DEVELOPMENT: CXCDS User Infrastructure Software
#
# DESCRIPTION:
#
#       This script configures the user environment for CIAO, the Chandra
#       X-Ray Center data analysis system.
#
#       When the script is sourced, it checks for the existence of an
#       ASCDS_INSTALL environment variable. If found, the script assumes
#       that the environment is already set up and exits with a warning
#       message. The user may override a previously set configuration by
#       setting the ASCDS_OVERRIDE environment variable (any value is
#       ok) and rerunning this script.
#
#       User customizations should be added to the 'USER CUSTOMIZATIONS'
#       section which appears slightly beyond the middle of this script.
#       If the user desires to modify the value of the installation root
#       (ASCDS_INSTALL) they should do so by setting the _nextASCDS_INSTALL
#       value at the beginning of the script. 
#
############################################################################

if ( $?ASCDS_INSTALL ) then

################################################################
#                set CIAO environment variables                #
################################################################

#  setenv DYLD_BIND_AT_LAUNCH 1

################################################################
#                       IPython Setup                          #
################################################################

   setenv IPYTHONDIR $HOME/.ipython-ciao

################################################################
#              Export variables to environment                 #
################################################################

#  setenv DYLD_BIND_AT_LAUNCH 1

if ( $?CIAO_HEADAS ) then
    setenv HEADAS $CIAO_HEADAS
endif

################################################################
#             setup AHELP_DEFCONTEXT if needed                 #
################################################################

   if ( $?AHELP_DEFCONTEXT ) then
      setenv AHELP_DEFCONTEXT "/py[.]*/"
   endif

################################################################
#                         Adjust paths                         #
################################################################

    if ( ${?path} ) then
	set path = ( $ASCDS_BIN $path )
    else
	set path = ( $ASCDS_BIN )
    endif

   if ( $?LD_LIBRARY_PATH ) then
      setenv LD_LIBRARY_PATH $ASCDS_INSTALL/lib:$LD_LIBRARY_PATH
   else
      setenv LD_LIBRARY_PATH $ASCDS_INSTALL/lib
   endif

   if ( $?CIAO_LD_LIBRARY_PATH ) then
      if ( $?LD_LIBRARY_PATH ) then
         setenv LD_LIBRARY_PATH $CIAO_LD_LIBRARY_PATH:$LD_LIBRARY_PATH
      else
         setenv LD_LIBRARY_PATH $CIAO_LD_LIBRARY_PATH
      endif
   endif

   if ( $?SLANG_SCRIPT_PATH ) then
       setenv SLANG_SCRIPT_PATH $ASCDS_INSTALL/share/slsh/local-packages:$SLANG_SCRIPT_PATH
   else
        setenv SLANG_SCRIPT_PATH $ASCDS_INSTALL/share/slsh/local-packages
   endif

   if ( $?SLANG_MODULE_PATH ) then
       setenv SLANG_MODULE_PATH $ASCDS_INSTALL/lib/slang/v2/modules:$SLANG_MODULE_PATH
   else
       setenv SLANG_MODULE_PATH $ASCDS_INSTALL/lib/slang/v2/modules
   endif

   if ( $?CIAO_SLSH_PATH ) then
       setenv CIAO_SLSH_PATH $ASCDS_INSTALL/share/slsh:$CIAO_SLSH_PATH
   else
       setenv CIAO_SLSH_PATH $ASCDS_INSTALL/share/slsh
   endif

   if ( $?PYTHONPATH ) then
       setenv PYTHONPATH $ASCDS_INSTALL/lib/python3.11/site-packages:$PYTHONPATH
   else
       setenv PYTHONPATH $ASCDS_INSTALL/lib/python3.11/site-packages
   endif

#  setenv BWIDGET_LIBRARY $ASCDS_LIB
#  if ( -d $ASCDS_INSTALL/Library/Frameworks ) then
#  setenv DYLD_FRAMEWORK_PATH $ASCDS_INSTALL/Library/Frameworks:$DYLD_FRAMEWORK_PATH
#  endif

################################################################
#                    Finished configuration                    #
################################################################

else
    echo "You need to setup you CIAO enviroment before"
    echo "running this script."
endif # end of if ($?ASCDS_INSTALL)  - DO NOT DELETE THIS LINE
