# 
#  Copyright (C) 2017-2018  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

"""

CXC History API.

"""

import sys
from .cxchistory import *
from .historyrecord import *
from .commentrecord import *


__all__ = ["CXCHistory",
           "HistoryRecord",
           "CommentRecord",
           ]


try:
    import ciao_version
    vstr = ciao_version.get_ciao_version()
except:
    print("Warning: Unable to load the ciao_version module to determine version number - defaulting 'pyregion' version to 0.0.0");
    vstr = "0.0.0"

__version__ = vstr
