#!/usr/bin/env python
# 
#  Copyright (C) 2007  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#


# May 17, 2007

# pyparamio.t.py
# this file

# pyparamio.t
# unix sh script, to activate pyparamio.t.py for running regression testing

# OUTFILE
# global variables exported in pyparamio.t


#------------  Beginning of Template ----------------------
# Support python 2 and 3
from __future__ import print_function

# import the package
from paramio import *
import os  #used for environment vars
import sys # used for version switch

#rename the function to get the environment variable for readability
getenv = os.environ.get

# get outfile by invoking environment variables
# exported from "pygrpglue.t"
TESTID     = getenv('TESTID')
if( TESTID == None ):
  print("No TESTID specified\n")

OUTFILE = getenv('OUTFILE')
if( OUTFILE != None):
  OutFilePtr = open (OUTFILE, 'w')
  if( OutFilePtr == None):
    print("Unable to open %s\n" % OUTFILE)

#------------  End of Template ----------------------


# !! 2
# Below are pecific subroutines for regression testing
#=============================================================================
#
#  --- Subroutines ---
#
#=============================================================================


# !!4
#=============================================================================
#
#   --- Main Routine ---
#
#=============================================================================

#Python does not have a native switch statement, so the code below
#tries to duplicate the C switch format/behavior

class switch(object):
    def __init__(self, value):
        self.value = value
        self.fall = False

    def __iter__(self):
        """Return the match method once, then stop"""
        yield self.match
        raise StopIteration

    def match(self, *args):
        """Indicate whether or not to enter a case suite"""
        if self.fall or not args:
            return True
        elif self.value in args:
            self.fall = True
            return True
        else:
            return False

#shape variables
pardict = dict(infile='in.fits', outfile='out.fits', clobber='yes')
parlist = ["dmextract","dmlist","dmcopy"]
args    = [ "dmcopy", "test.fits", "out=out.fits", "cl+" ]

#Switch statement for TESTID
for case in switch(TESTID):
  if case('test1'):
      print("running  test1", file=OutFilePtr)
      punlearn("dmextract")
      fp = paramopen("dmextract")
      print("The opt parameter=%s" % pget(fp,"opt"), file=OutFilePtr)
      paramclose( fp )
      break
  if case('test2'):
      print("running  test2", file=OutFilePtr)
      punlearn("dmcopy")
      pset("dmcopy","verbose","3")
      print(pget("dmcopy","verbose"), file=OutFilePtr)
      break
  if case('test3'):
      print("running  test3", file=OutFilePtr)
      punlearn("dmcopy")
      ifile = pget("dmcopy","infile")
      clval = pget("dmcopy","clobber")
      print(ifile, file=OutFilePtr)
      if (ifile == ""):
        print("infile is empty", file=OutFilePtr)
      print(clval, file=OutFilePtr)
      break
  if case('test4'):
      print("running  test4", file=OutFilePtr)
      punlearn("dmcopy")
      fp = paramopen("dmcopy","rH")
      ifile = pget(fp,"infile")
      paramclose(fp)
      if (ifile == ""):
        print("infile is empty", file=OutFilePtr)
      break
  if case('test5'):
      print("running  test5", file=OutFilePtr)
      punlearn("dmcopy")
      clval = pquery("dmcopy","clobber")
      print(clval, file=OutFilePtr)
      break
  if case('test6'):
      print("running  test6", file=OutFilePtr)
      punlearn("dmcopy")
      fp = paramopen("dmcopy","rw", args )
      ifile = pquery( fp, "infile" )
      print(ifile, file=OutFilePtr)
      ofile = pquery( fp, "outfile" )
      print(ofile, file=OutFilePtr)
      clval = pquery( fp, "clobber" )
      print(clval, file=OutFilePtr)
      paramclose( fp )
      print(pget( "dmcopy", "outfile" ), file=OutFilePtr)
      print(pget( "dmcopy", "clobber" ), file=OutFilePtr)
      break
  if case('test7'):
      print("running  test7", file=OutFilePtr)
      punlearn("dmcopy")
      fp = paramopen( "dmcopy" )
      print(paccess( fp, "infile" ), file=OutFilePtr)
      print(paccess( fp, "value" ), file=OutFilePtr)
      paramclose( fp )
      break
  if case('test8'):
      print("running  test8", file=OutFilePtr)
      punlearn("dmextract")
      ifile = pget("dmextract","infile")
      if (ifile == ""):
        print("infile is empty", file=OutFilePtr)
      punlearn(["dmextract","dmlist","dmcopy"])
      clval= pget("dmextract","clobber")
      verbose = pget("dmlist","verbose")
      icopyfile = pget("dmcopy","infile")
      if (clval == "no"):
        print("clobber = no", file=OutFilePtr)
      if (verbose == "0"):
        print("verbose = 0", file=OutFilePtr)
      if (icopyfile == ""):
        print("infile copy is empty", file=OutFilePtr)
      break
  if case('test9'):
      print("running  test9", file=OutFilePtr)
      punlearn("dmextract")
      err = pgetd( "dmextract", "sys_err" )
      print(err, file=OutFilePtr)
      if sys.version_info[0] >= 3:
         type_str = type(err).__name__
         if (type_str == "<class 'float'>"):
            print("float", file=OutFilePtr)
         else:
            print(type_str, file=OutFilePtr)
      else:         
         print(type(err).__name__, file=OutFilePtr)

      vali = pgeti( "dmextract", "verbose" )
      vald = pgetd( "dmextract", "verbose" )
      valstr = pgetstr( "dmextract", "verbose" )
      print("i=%d d=%f str=%s" % (vali, vald, valstr), file=OutFilePtr)
      if sys.version_info[0] >= 3:
         type_str = type(vali).__name__
         if(type_str == "<class 'int'>"):
            print("int", file=OutFilePtr)
         else:
            print(type_str, file=OutFilePtr)
         type_str = type(vald).__name__
         if(type_str == "<class 'int'>"):
            print("float", file=OutFilePtr)
         else:
            print(type_str, file=OutFilePtr)
         type_str = type(valstr).__name__
         if(type_str == "<class 'str'>"):
            print("str", file=OutFilePtr)
         else:
            print(type_str, file=OutFilePtr)
      else:
         print(type(vali).__name__, file=OutFilePtr)
         print(type(vald).__name__, file=OutFilePtr)
         print(type(valstr).__name__, file=OutFilePtr)
      break
  if case('test10'):
      print("running  test10", file=OutFilePtr)
      punlearn("dmcopy")
      pputd("dmcopy", "verbose",1)
      clval = pgetd("dmcopy","verbose")
      pputd(b"dmcopy", b"verbose",2)
      clval1 = pgetd("dmcopy","verbose")
      pputd(u"dmcopy", u"verbose",3)
      clval2 = pgetd("dmcopy","verbose")
      if(clval == 1 and clval1 == 2 and clval2 == 3):
         print("dmcopy pputd verbose is correct " , file=OutFilePtr)
      else:
         print("dmcopy pputd verbose is NOT correct " , file=OutFilePtr)
#
      pputi("dmcopy", "verbose",1)
      clval = pgeti("dmcopy","verbose")
      pputi(b"dmcopy", b"verbose",2)
      clval1 = pgeti("dmcopy","verbose")
      pputi(u"dmcopy", u"verbose",3)
      clval2 = pgeti("dmcopy","verbose")
      if(clval == 1 and clval1 == 2 and clval2 == 3):
         print("dmcopy pputi verbose is correct " , file=OutFilePtr)
      else:
         print("dmcopy pputi verbose is NOT correct " , file=OutFilePtr)
#

      pputstr("dmcopy", "verbose","1")
      clval = pgetstr("dmcopy","verbose")
      pputstr(b"dmcopy", b"verbose",b"2")
      clval1 = pgetstr("dmcopy","verbose")
      pputstr(u"dmcopy", u"verbose",u"3")
      clval2 = pgetstr("dmcopy","verbose")
      if(clval == "1" and clval1 == "2" and clval2 == "3"):
         print("dmcopy pputstr verbose is correct " , file=OutFilePtr)
      else:
         print("dmcopy pputstr verbose is NOT correct " , file=OutFilePtr)
#
      punlearn("dmextract")
      pset("dmextract","verbose","1")
      clval = pget("dmextract", "verbose")
      pset(b"dmextract",b"verbose",b"1")
      clval1 = pget("dmextract", "verbose")
      pset(u"dmextract",u"verbose", u"1")
      clval2 = pget("dmextract", "verbose")
      if( clval == clval1):
         print("extract - native and byte pset are equal", file=OutFilePtr)
      else:
         print("extract - native and byte pset are NOT equal", file=OutFilePtr)
      if( clval == clval2):
         print("extract - native and unicode pset are equal", file=OutFilePtr)
      else:
         print("extract - native and unicode pset are NOT equal", file=OutFilePtr)
#      
      punlearn("dmcopy")
      clval = pquery("dmcopy","clobber")
      clval1 = pquery(b"dmcopy",b"clobber")
      clval2 = pquery(u"dmcopy",u"clobber")
      if( clval == clval1):
         print("dmcopy - native and byte \"query\" are equal", file=OutFilePtr)
      else:
         print("dmcopy - native and byte \"query\" are NOT equal", file=OutFilePtr)
      if( clval == clval2):
         print("dmcopy - native and unicode \"query\" are equal", file=OutFilePtr)
      else:
         print("dmcopy - native and unicode \"query\" are NOT equal", file=OutFilePtr)
#      
      punlearn("dmcopy")
      fp = paramopen("dmcopy")
      clval = paccess( fp, "infile" )
      clval1 = paccess( fp, b"infile" )
      clval2 = paccess( fp, u"infile" )
      if( clval == clval1):
        print("dmcopy - native and byte \"paccess\" are equal", file=OutFilePtr)
      else:
        print("dmcopy - native and byte \"paccess\" are NOT equal", file=OutFilePtr)
      if( clval == clval2):
        print("dmcopy - native and unicode \"paccess\" are equal", file=OutFilePtr)
      else:
        print("dmcopy - native and unicode \"paccess\" are NOT equal", file=OutFilePtr)
      paramclose(fp)  
#     
      cval = paccess( "dmcopy", "value" )
      cval1 = paccess( b"dmcopy", b"value" )
      cval2 = paccess( u"dmcopy", u"value" )
      if( clval == clval1):
        print("dmcopy - native and byte \"value\" are equal", file=OutFilePtr)
      else:
        print("dmcopy - native and byte \"value\" are NOT equal", file=OutFilePtr)
      if( clval == clval2):
        print("dmcopy - native and unicode \"value\" are equal", file=OutFilePtr)
      else:
        print("dmcopy - native and unicode \"value\" are NOT equal", file=OutFilePtr)
#
      try:
        paramgetpath()
      except ValueError:
        pass
      except Exception as ex:
        print(str(ex), file=OutFilePtr)

      clval = paramgetpath("dmlist")
      clval1 = paramgetpath(b"dmlist")
      clval2 = paramgetpath(u"dmlist")
      if( clval == clval1):
        print("dmlist - native and byte \"paramgetpath\" are equal", file=OutFilePtr)
      else:
        print("dmlist - native and byte \"paramgetpath\" are NOT equal", file=OutFilePtr)
      if( clval == clval2):
        print("dmlist - native and unicode \"paramgetpath\" are equal", file=OutFilePtr)
      else:
        print("dmlist - native and unicode \"paramgetpath\" are NOT equal", file=OutFilePtr)
#
      clval = punlearn("dmlist")
      clval1 = punlearn(b"dmlist")
      clval2 = punlearn(u"dmlist")
      if( clval == clval1):
        print("dmlist - native and byte \"punlearn\" are equal", file=OutFilePtr)
      else:
        print("dmlist - native and byte \"punlearn\" are NOT equal", file=OutFilePtr)
      if( clval == clval2):
        print("dmlist - native and unicode \"punlearn\" are equal", file=OutFilePtr)
      else:
        print("dmlist - native and unicode \"punlearn\" are NOT equal", file=OutFilePtr)
#
      try:
        plist()
      except ValueError:
        pass
      except Exception as ex:
        print(str(ex), file=OutFilePtr)

      clval = plist("dmextract")
      clval1 = plist(b"dmextract")
      clval2 = plist(u"dmextract")
      if(clval1 == clval):
        print ("plist byte and native same list", file=OutFilePtr)
      else:
        print ("plist byte and native not same list", file=OutFilePtr)
      if(clval2 == clval):
        print ("plist unicode and native same list", file=OutFilePtr)
      else:
        print ("plist unicode and native not same list", file=OutFilePtr)

      threeK = "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"

      punlearn("dmlist")
      try:
        pset("dmlist", "infile", threeK )
      except ValueError:
        pass
      except Exception as ex:
        print(str(ex), file=OutFilePtr)

      break

  if case(): # default
      print("Invalid TESTID")
OutFilePtr.close()
