# 
#  Copyright (C) 2010-2011  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#


from pycrates.io.CrateIO import *
from pycrates.io.dm_backend import *

klist = []

# Define a list containing an instance of each available kernel
dm = DMIO()
klist.append(dm)

def select( input ):

    retval = None

    if type(input) is str:
        if input.find(".fits"):
            retval = DMIO()
        elif input.find(".txt"):
            retval = DMIO()

    else:
        for ii in range(len(klist)):
            if klist[ii].canHandle( input ):
                retval = klist[ii]
    
    return retval
        

