from datetime import datetime

from ciao.tools.configuration import Configuration, Integer, Float, Parameter, Boolean, String


class Header(Configuration):
    def set_key(self, name, value):
        if name not in self.__parameters__:
            if not hasattr(self, '__undefined_parameters__'):
                self.__undefined_parameters__ = {}
            self.__undefined_parameters__[name] = Parameter(type(value), name=name)
        setattr(self, name, value)

    @property
    def names(self):
        result = self.__parameters__.keys()
        if hasattr(self, '__undefined_parameters'):
            result += self.__undefined_parameters__.keys()
        return result

    def __iter__(self):
        defined_parameters = [(name, getattr(self, name)) for name in self.__parameters__.keys()]
        if hasattr(self, '__undefined_parameters__'):
            undefined_parameters = [(name, getattr(self, name)) for name in self.__undefined_parameters__.keys()]
        else:
            undefined_parameters = []
        return iter(defined_parameters + undefined_parameters)


def make_empty_header():
    new_header_class = type("EmptyHeader", (Header, ), {'__parameters__': {}})
    return new_header_class()


IntegerKey = Integer
FloatKey = Float
BooleanKey = Boolean
StringKey = String


class IsoUtcNow(StringKey):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs, default=now())


def now():
    curr_date = datetime.utcnow().isoformat()
    return curr_date.split('.')[0]
