# This file is generated by numpy's build process
# It contains system_info results at the time of building this package.
from enum import Enum
from numpy.core._multiarray_umath import (
    __cpu_features__,
    __cpu_baseline__,
    __cpu_dispatch__,
)

__all__ = ["show"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return {k: _cleanup(v) for k, v in d.items() if v and _cleanup(v)}
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "12.3.0",
                "commands": r"/home/conda/feedstock_root/build_artifacts/numpy_1707225376651/_build_env/bin/x86_64-conda-linux-gnu-cc",
                "args": r"-march=nocona, -mtune=haswell, -ftree-vectorize, -fPIC, -fstack-protector-strong, -fno-plt, -O2, -ffunction-sections, -pipe, -isystem, /opt/conda/envs/ciao-4.17.0/include, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/numpy_1707225376651/work=/usr/local/src/conda/numpy-1.26.4, -fdebug-prefix-map=/opt/conda/envs/ciao-4.17.0=/usr/local/src/conda-prefix, -DNDEBUG, -D_FORTIFY_SOURCE=2, -O2, -isystem, /opt/conda/envs/ciao-4.17.0/include",
                "linker args": r"-Wl,-O2, -Wl,--sort-common, -Wl,--as-needed, -Wl,-z,relro, -Wl,-z,now, -Wl,--disable-new-dtags, -Wl,--gc-sections, -Wl,--allow-shlib-undefined, -Wl,-rpath,/opt/conda/envs/ciao-4.17.0/lib, -Wl,-rpath-link,/opt/conda/envs/ciao-4.17.0/lib, -L/opt/conda/envs/ciao-4.17.0/lib, -march=nocona, -mtune=haswell, -ftree-vectorize, -fPIC, -fstack-protector-strong, -fno-plt, -O2, -ffunction-sections, -pipe, -isystem, /opt/conda/envs/ciao-4.17.0/include, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/numpy_1707225376651/work=/usr/local/src/conda/numpy-1.26.4, -fdebug-prefix-map=/opt/conda/envs/ciao-4.17.0=/usr/local/src/conda-prefix, -DNDEBUG, -D_FORTIFY_SOURCE=2, -O2, -isystem, /opt/conda/envs/ciao-4.17.0/include",
            },
            "cython": {
                "name": "cython",
                "linker": r"cython",
                "version": "3.0.8",
                "commands": r"cython",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "12.3.0",
                "commands": r"/home/conda/feedstock_root/build_artifacts/numpy_1707225376651/_build_env/bin/x86_64-conda-linux-gnu-c++",
                "args": r"-fvisibility-inlines-hidden, -fmessage-length=0, -march=nocona, -mtune=haswell, -ftree-vectorize, -fPIC, -fstack-protector-strong, -fno-plt, -O2, -ffunction-sections, -pipe, -isystem, /opt/conda/envs/ciao-4.17.0/include, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/numpy_1707225376651/work=/usr/local/src/conda/numpy-1.26.4, -fdebug-prefix-map=/opt/conda/envs/ciao-4.17.0=/usr/local/src/conda-prefix, -DNDEBUG, -D_FORTIFY_SOURCE=2, -O2, -isystem, /opt/conda/envs/ciao-4.17.0/include",
                "linker args": r"-Wl,-O2, -Wl,--sort-common, -Wl,--as-needed, -Wl,-z,relro, -Wl,-z,now, -Wl,--disable-new-dtags, -Wl,--gc-sections, -Wl,--allow-shlib-undefined, -Wl,-rpath,/opt/conda/envs/ciao-4.17.0/lib, -Wl,-rpath-link,/opt/conda/envs/ciao-4.17.0/lib, -L/opt/conda/envs/ciao-4.17.0/lib, -fvisibility-inlines-hidden, -fmessage-length=0, -march=nocona, -mtune=haswell, -ftree-vectorize, -fPIC, -fstack-protector-strong, -fno-plt, -O2, -ffunction-sections, -pipe, -isystem, /opt/conda/envs/ciao-4.17.0/include, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/numpy_1707225376651/work=/usr/local/src/conda/numpy-1.26.4, -fdebug-prefix-map=/opt/conda/envs/ciao-4.17.0=/usr/local/src/conda-prefix, -DNDEBUG, -D_FORTIFY_SOURCE=2, -O2, -isystem, /opt/conda/envs/ciao-4.17.0/include",
            },
        },
        "Machine Information": {
            "host": {
                "cpu": "x86_64",
                "family": "x86_64",
                "endian": "little",
                "system": "linux",
            },
            "build": {
                "cpu": "x86_64",
                "family": "x86_64",
                "endian": "little",
                "system": "linux",
            },
            "cross-compiled": bool("False".lower().replace("false", "")),
        },
        "Build Dependencies": {
            "blas": {
                "name": "blas",
                "found": bool("True".lower().replace("false", "")),
                "version": "3.9.0",
                "detection method": "pkgconfig",
                "include directory": r"/opt/conda/envs/ciao-4.17.0/include",
                "lib directory": r"/opt/conda/envs/ciao-4.17.0/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"/opt/conda/envs/ciao-4.17.0/lib/pkgconfig",
            },
            "lapack": {
                "name": "dep140567732183440",
                "found": bool("True".lower().replace("false", "")),
                "version": "1.26.4",
                "detection method": "internal",
                "include directory": r"unknown",
                "lib directory": r"unknown",
                "openblas configuration": r"unknown",
                "pc file directory": r"unknown",
            },
        },
        "Python Information": {
            "path": r"/opt/conda/envs/ciao-4.17.0/bin/python",
            "version": "3.11",
        },
        "SIMD Extensions": {
            "baseline": __cpu_baseline__,
            "found": [
                feature for feature in __cpu_dispatch__ if __cpu_features__[feature]
            ],
            "not found": [
                feature for feature in __cpu_dispatch__ if not __cpu_features__[feature]
            ],
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which NumPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    See Also
    --------
    get_include : Returns the directory containing NumPy C
                  header files.

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )
