# 
#  Copyright (C) 2012-2014  Smithsonian Astrophysical Observatory
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

from region import *

class CrateSubspaceData:

    def __init__(self):
        self.__clear__()

    def __eq__(self, other):
        return str(self) == str(other)

    def __clear__(self):
        self.name = ""
        self.cpts = []
        self.table_name = ""
        self.unit = ""
        self.range_min = []
        self.range_max = []
        self.region = None


    def __str__(self):
        return self.__repr__()


    def __repr__(self):

        retstr = "   Name:            " + self.name

        ncpts = len(self.cpts)

        if ncpts > 0:
            retstr = retstr +  ": "
            for ii in range(ncpts):
                retstr = retstr + self.cpts[ii]
                if ii != ncpts-1:
                    retstr = retstr +  ", "
        
        retstr = retstr +  "\n"


        if self.table_name != "":
            retstr += "   Table Name:      " + self.table_name + "\n"
        retstr += "   Unit:            " + self.unit + "\n"
        retstr += "   Range Minimum:   " + str(self.range_min) + "\n"
        retstr += "   Range Maximum:   " + str(self.range_max) + "\n"

        if self.region is not None:
            retstr += "   Region String:   " + regRegionString(self.region) + "\n"
        else:
            retstr += "   Region String:   DEFAULT\n"

        return retstr


        
