local tostring = tostring
local vobj    = require( 'saotrace.raygen.validate').vobj:new()
local load    = require( 'saotrace.raygen.source.load' )
local factory = require( 'saotrace.raygen.source.simple.factory' )

local MSC_to_raygen_polar = require( 'chandra.saotrace.coords' ).MSC_to_raygen_polar

local position = require( 'chandra.saotrace.raygen.sources.position' ).vspec
local spectrum = require( 'saotrace.raygen.spectrum.vspec' ):new():vspec()

local function convert_MSC_raygen( arg )

   -- MSC_to_raygen_polar doesn't convert if theta == 0
   local theta, phi = MSC_to_raygen_polar( 10, arg[1] )
   arg[1] = phi
   return true, arg

end


local M = factory.create( function( vspec )

			     if vspec.rotate ~= nil then
				vspec.rotate.postcall = convert_MSC_raygen
			     end

			     vspec.position = position
			     vspec.spectrum = spectrum
			  end
		       )


function M.load_sources( file, args )

   local vspec = {
      ra_aimpt  = { type = 'angle_ra', optional = true },
      dec_aimpt = { type = 'angle_dec', optional = true },
      scale     = { type = 'number', optional = true }
   }

   local ok, args = vobj:validate( vspec, args )
   assert( ok, args )

   local src_id = 0

   load.load_sources( file,
		      {
			 position = position,
			 before = function (srcpars, source)
				     src_id = src_id + 1
				     if srcpars.name then
					srcpars.name = tostring(srcpars.name)
				     else
					srcpars.name = file .. ': ' .. src_id
				     end

				     if args.scale then
					for _,spectrum in ipairs( srcpars.spectrum ) do
					   if spectrum.scale then
					      spectrum.scale = spectrum.scale * args.scale
					   else
					      spectrum.scale = args.scale
					   end
					end
				     end

				     if srcpars.position and srcpars.position.ra then
					if not ( args.ra_aimpt and args.dec_aimpt ) then
					   error( "must specify ra_aimpt & dec_aimpt in call to load_sources() for:\n"..tostring(source) )
					end
					srcpars.position.ra_aimpt = args.ra_aimpt
					srcpars.position.dec_aimpt = args.dec_aimpt
				     end

				     return srcpars
				  end
		      }
		   )

end

return M
