-- --8<--8<--8<--8<--
--
-- Copyright (C) 2011 Smithsonian Astrophysical Observatory
--
-- This file is part of saotrace.aperture
--
-- saotrace.aperture is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or (at
-- your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--
-- -->8-->8-->8-->8--

local seq = require('pl.seq')

local require = require
local assert = assert
local string = require('string')
local error = error
local ipairs = ipairs

local aperture = require( 'saotrace.aperture' )
local geometry = require( 'saotrace.geometry' )
local ideal    = require( 'saotrace.baffles.ideal' )
local rdb = require('rdb')
local tables = require( 'saotrace.suplib.tables' )

local vobj = require( 'validate.args' ):new()
vobj:setopts{ named = true}

module( ... )


function create_baffles( ... )

   local vspec = tables.copy( ideal.vspec, true )
   vspec.name = { type = 'string' }

   local ok, args = vobj:validate( vspec, ... )
   assert( ok, args )

   local name = args.name
   args.name = nil

   local inner, outer = ideal.create( args )

   inner.label = name .. ' inner'
   inner.pass  = false

   outer.label = name .. ' outer'
   outer.pass  = true


   aperture.begin_assembly( )
   for _, ap in ipairs{ inner, outer } do

      aperture.begin_subassembly()
      aperture.translate( ap.x, ap.y, ap.z )
      aperture.circle( ap.r, true, ap.pass, { label = ap.label } )
      aperture.end_subassembly()

   end
   aperture.end_assembly()

end


config = require('saotrace.config').aperture
config.script.func = create_baffles


return { create_baffles = create_baffles,
	 vspec = vspec
      }
