local box = require('saotrace.suplib.box')
local tables = require('saotrace.suplib.tables')

-- require('string')

local _M = {}
local _G = _G

function _M.init( cfgfile, cfgpars )

   local config = require ( 'saotrace.config' ).raygen

   local construct = false
   local env

   -- load intrinsic wrappers into _G

   for _, module in pairs( { 'jitter', 'extent', 'spectrum', 'ea', 'source', 'units' } ) do
      _G[module] = require( 'saotrace.raygen.' .. module  )
   end


   -- initialize logging singleton
   logger = require ('saotrace.raygen.log').logger

   if cfgfile and cfgfile:len() > 0 then

      local boxenv, retval = box.boxit( _G, cfgfile, true )

      -- if cfgfile returns a table, use that as the
      -- environment, not the sandboxed one
      env = type(retval) == 'table' and retval or boxenv

   end

   if cfgpars and cfgpars:len() > 0 then

      -- use the env determined from cfgfile (if it was run)
      -- else create another

      if env then

	 -- make sure this environment sees the global one
	 setmetatable( env, { __index = _G } )

	 box.boxit( env, cfgpars )

      else

	 local boxenv, retval = box.boxit( _G, cfgpars, true )
	 env = type(retval) == 'table' and retval or boxenv

      end

   end

   -- source arguments are in sources.args
   -- ea arguments are in ea.args
   -- jitter arguments are in jitter.args

   env = env or {}
   setmetatable( env, { __index = _G } )

   for _, name in ipairs { 'sources', 'jitter', 'entrance_aperture' } do

      local component = config.scripts[name]

      -- if no args have been assigned, pass in the
      -- environment populated by the sandbox.  this
      -- makes it easier to provide backwards compatibility
      -- perform a shallow copy into a fresh table, so there
      -- is no metatable (set above to get values from _G)
      -- this ensures that the strict module doesn't get
      -- all crazy in validate.args()
      if not component.args then
	 component.args = tables.copy( env )
      end

      if component.func ~= nil then
	 box.boxit( env, component.func, false, component.args )
      end

      if component.cleanup ~= nil then

	 box.boxit( env, component.cleanup, false, component.args )
      end

   end

end


return _M
