local pairs = pairs
local print = print
local assert = assert
local type = type
local table = require( 'table' )

local RDB = require( 'rdb' )
local tables = require('saotrace.suplib.tables')

local raygen = require('saotrace.raygen')
local ea   = require('saotrace.raygen.ea')

local vobj = require('saotrace.raygen.validate').vobj:new()

local M = {}
setfenv( 1, M )

vspec = {}

vspec.create_from_db = {
      file  = { type = 'string' },
      match = { type = { 'function', 'table' } },
      type  = { vfunc = function( arg )
			   if ea.vspec[arg] ~= nil then
			      return true, arg
			   else
			      return false, "unknown entrance aperture type: " .. arg
			   end
			end,
	     },
      col = { type = 'table', default = {} },
      format = { enum = 'rdb', default = 'rdb' }
   }

function create_from_db( ... )

   local ok, args = vobj:validate(vspec.create_from_db, ... )

   assert( ok, args )

   -- a list of the parameters for this entrance aperture type
   local pars = tables.keys( ea.vspec[args.type][2].vtable )

   local eafunc = ea[args.type]

   local matches = {}
   local nmatches = 0
   local select

   if args.format == 'rdb' then

      select = RDB.select{ file = args.file,
			   match = args.match,
			   mode = 'iterator' }

   end

   for rec, idx in select do

      nmatches = nmatches + 1

      local tag = table.concat( { args.file, idx }, ':' )

      eafunc( tag, tables.extract( rec, pars, args.col ) )

   end

   return nmatches

end

return M
