local ea = require('saotrace.raygen.ea.ideal')
local source = require( 'saotrace.raygen.source.simple' )
local tables = require( 'saotrace.suplib.tables' )

local require = require
local pairs   = pairs
local type    = type

local M = {}
setfenv( 1, M )

config = require( 'saotrace.config' ).raygen

-- sanitize arguments sent to saotrace.raygen.ea.ideal.entrance_aperture
-- args may be an environment returned by boxing a load of a file or string,
-- so may trigger an "unexpected elements" validation error

function ea_wrap( args )

   return ea.entrance_aperture( tables.filter_matched_keys( ea.vspec, args ) )

end

-- trace-shell needs to provide the shell & db parameters
-- in config.scripts.entrance_aperture.args
config.scripts.entrance_aperture.func = ea_wrap

-- use the cleanup hook to ensure handle backwards compatibility
config.scripts.sources.cleanup = source.default

-- export a clean namespace with just the functions for the sources
-- and jitter
export = tables.filter( source,
			function (k,v)
			   return type(v) == 'function' and k ~= 'default'
			end
		     )

return export
