local select = select
local setmetatable = setmetatable
local tostring = tostring
local assert = assert
local error = error
local next = next
local table = require('table')
local RDB = require('rdb')

local raygen = require( 'saotrace.raygen' )
local spectrum = require( 'saotrace.raygen.spectrum' )

local M = {}
setfenv( 1, M )

Spectra = {
   add = function( self, spectrum )
	    self._spectra[#self._spectra+1] = spectrum
	 end,
   name = function( self, name )
	     return self:tag() .. tostring( name )
	  end,
   next = function( self )
	     return #self._spectra+1
	  end,
   tag  = function( self, ... )
	     local old_tag = self._tag
	     if select( '#', ... ) > 0 then
		self._tag = select(1, ... )
	     end
	     return old_tag
	  end,
   spectra = function( self )
		if next(self._spectra) ~= nil then
		   return self._spectra
		else
		   return
		end
	     end,
}

function Spectra:new( )
   local obj = {}
   obj._spectra = {}
   obj._tag = ''
   setmetatable( obj, self )
   self.__index = self;
   return obj
end


function picket( arg, vfarg )

   local rdb = assert( RDB( arg.file ) )
   local spectra = vfarg.va:getopt('udata').spectra
   local cols = arg.flux and { arg.energy, arg.flux } or { arg.energy }

   local badcol = rdb:chk_cols( cols )
   if badcol ~= nil  then
      error( arg.file .. ': missing column ' .. badcol )
   end

   local row = rdb:read()
   local index = 0
   while row do
      index = index + 1
      spectra:add (
	 spectrum.mono{
	    name  = spectra:name( table.concat( {spectra:next(),
						 arg.file, index }, ':' ) ),
	    energy = row[arg.energy],
	    flux = arg.flux and row[arg.flux] or 1
	 }

      )
      row = rdb:read()
   end

   rdb:close()

end

return M
