/*
 \input ccom
 \section{bpipe_axaf.h}
*/

/* --8<--8<--8<--8<--
 *
 * Copyright (C) 2005-2011 Smithsonian Astrophysical Observatory
 *
 * This file is part of bpipe
 *
 * bpipe is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * -->8-->8-->8-->8-- */

#ifndef _BPIPE_AXAF_H
#define _BPIPE_AXAF_H

#include <bpipe/bpipe.h>

/*
photon information:

field		  name		      macro name		type
---------	  ----		      ----------		----
arrival time	  time		      BP_AXAF_time		double
direction vector  direction	      BP_AXAF_phot_dir		DVector3
energy		  energy	      BP_AXAF_phot_energy	double
grazing angle	  graze_angle	      BP_AXAF_phot_graze_angle	double
id		  id		      BP_AXAF_phot_id		unsigned int
intersect bcs     intersect_bcs       BP_AXAF_intersect_bcs     DVector3
mirror pair	  mirror_pair	      BP_AXAF_mirror_pair	unsigned char
pathlength	  path_length	      BP_AXAF_path_length	double
position	  position	      BP_AXAF_phot_pos		DVector3
ring number	  ring		      BP_AXAF_ring		unsigned int
spoke number	  spoke		      BP_AXAF_spoke		unsigned int
osac ray status   osac_raycode	      BP_AXAF_osac_raycode	int
surface normal	  surface_norm	      BP_AXAF_surf_norm		DVector3
weight		  weight	      BP_AXAF_phot_wt		double
polar. sine comp. polarization_sine   BP_AXAF_pol_sin		DCVector2
polar. cos  comp. polarization_cosine BP_AXAF_pol_cos		DCVector2
surf missed flags surf_missed	      BP_AXAF_surf_missed	unsigned int
surf number       srfno	              BP_AXAF_srfno     	unsigned int

parameter stuff:

parameter	  name		      macro name		type
---------	  ----		      ----------		----
# of photons	  n_photons	      BP_AXAF_n_photons		unsigned int
# of rings	  n_rings	      BP_AXAF_n_rings		unsigned int
# of spoke	  n_spokes	      BP_AXAF_n_spokes		unsigned int
# of surfaces	  n_surfaces	      BP_AXAF_n_surfaces	unsigned int

*/

/*
Note:  use underscores rather than spaces to separate words 
       (as in "mirror_pair").
*/

#define BP_AXAF_time			"time"
#define BP_AXAF_phot_dir		"direction"
#define BP_AXAF_phot_energy		"energy"
#define BP_AXAF_phot_graze_angle	"graze_angle"
#define BP_AXAF_phot_id			"id"
#define BP_AXAF_mirror_pair		"mirror_pair"
#define BP_AXAF_path_length		"path_length"
#define BP_AXAF_phot_pos		"position"
#define BP_AXAF_ring			"ring"
#define BP_AXAF_spoke			"spoke"
#define BP_AXAF_surf_norm		"surface_norm"
#define BP_AXAF_phot_wt			"weight"
#define BP_AXAF_pol_sin			"polarization_sine"
#define BP_AXAF_pol_cos			"polarization_cosine"
#define BP_AXAF_surf_missed		"surf_missed"
#define BP_AXAF_osac_raycode 		"osac_ray_status"
#define BP_AXAF_srfno   		"srfno"
#define BP_AXAF_intersect_bcs           "intersect_bcs"

#define BP_AXAF_nphotons		"n_photons"
#define BP_AXAF_nrings			"n_rings"
#define BP_AXAF_nspokes			"n_spokes"
#define BP_AXAF_nsurfaces		"n_surfaces"

#endif /* *<_BPIPE_AXAF_H>* */
