#ifndef BITMASK_H
#define BITMASK_H

/*H**************************************************************************
 *
 * Source     : bitmask.h
 * Author     : T. J. Gaetz
 * Version    : 0.0.1
 * Id String  : $Id: bitmask.h,v 1.1 2004/03/16 15:49:44 dtn Exp $
 *
 * Description: bitmask_t typedef; bitmask macros
 *
 * History:
 *   19960617[tjg]: split into separate file
 *H*/

typedef unsigned int bitmask_t;

#define BITMASK(b) (1 << (b))
#define BITSET(a,b) ((a) |= BITMASK(b))
#define BITCLEAR(a,b) ((a) &= ~BITMASK(b))
#define BITTEST(a,b) (!(!((a) & BITMASK(b))))

#endif /* BITMASK_H */
