#ifndef IRB_H
#define IRB_H

/*H**************************************************************************
 *
 * Source     : irb.h
 * Author     : T. Gaetz
 * Version    : 0.0.2
 * Date Begun : 93-___-__ [T. Gaetz]
 * Last Rev   : 93-Nov-22 [T. Gaetz]
 * Id String  : $Id: irb.h,v 1.1 2004/03/16 15:49:55 dtn Exp $
 *
 * Description: input ray bundle and point source specification
 *
 * History:
 *    931122[tjg]: reformat header comments
 *
 *H*/

/*--- Point Source struct --------------------------------------------*/

typedef struct {
    double v[3];      /* ray direction (unit vector)                    */
    double d;         /* distance to point source                       */
    double energy;    /* photon energy                                  */
    double ecc;       /* polarization parameter                         */
    double cpsi;      /* polarization parameter                         */
    double spsi;      /* polarization parameter                         */
    double sqre;      /* polarization parameter                         */
} PtSrc;

typedef PtSrc *P_PTSRC;

/*--- Input Ray Bundle struct ----------------------------------------*/

typedef struct {
    double   cen[3];   /* x,y,z coordinates of input ray annulus center  */
    double   azbu;     /* azimuth of ray bundle source point (radians)   */
    double   elbu;     /* elevation of ray bundle source point (radians) */
    double   zdist;    /* distance of plane containing point source      */
    double   ri;       /* ray bundle annulus inner radius                */
    double   ro;       /* ray bundle annulus outer radius                */
    double   azlin;    /* azimuth angle for line source                  */
    double   angmin;   /* min angle for line source rays                 */
    double   angmax;   /* max angle for diffuse (or line source) rays    */
    double   cs1min;   /* 1 - cos(angmin)                                */
    double   cs1max;   /* 1 - cos(angmax)                                */
    int      srctype;  /* 0 for point, 1 for diffuse, 2 for radial line  */
} IRB;

typedef IRB *P_IRB;

#endif /* IRB_H ----------------------- END OF FILE -----------------------*/
