#ifndef OSACGI_H
#define OSACGI_H

/*H**************************************************************************
 *
 * FILENAME:      osacgi.h
 *
 * DESCRIPTION:
 *    catchall for gi file parameters which have no other home
 *
 * USAGE:
 *
 * NOTES:
 *
 * AUTHOR:
 *    T. J. Gaetz
 *
 * $Id: osacgi.h,v 1.1 2004/03/16 15:50:00 dtn Exp $
 *
 * RCS LOG:
 *    $Log: osacgi.h,v $
 *    Revision 1.1  2004/03/16 15:50:00  dtn
 *
 *    autotool the lib.  The following things were done to the package:
 *        . The following global substitution was done:
 *    	sed 's/BESJN/BESSJN/g' < *.f
 *          since BESJN is an intrinsic function on linux boxes.
 *
 *        .  The following lines in the file cleg4.f was changed from:
 *
 *             IF ( nfour .eq. 0 ) THEN
 *                CALL ABLEG4 (ZN, CT, ST, DEFC (1), DEFC (NLEG + 1),
 *         1           DEFC (NLEG * NFOUR + NLEG + 1), Q1, QT1, QZ1, IER, 1)
 *             ELSE
 *                CALL ABLEG4 (ZN, CT, ST, DEFC (1), DEFC (NLEG + 1),
 *         1           DEFC (NLEG * NFOUR + NLEG + 1), Q1, QT1, QZ1, IER, nfour)
 *             END IF
 *
 *          to (the word nfour is beyond the Fortran 72 char limit) :
 *
 *             IF ( nfour .eq. 0 ) THEN
 *                CALL ABLEG4 (ZN, CT, ST, DEFC (1), DEFC (NLEG + 1),
 *         1      DEFC (NLEG * NFOUR + NLEG + 1), Q1, QT1, QZ1, IER, 1)
 *             ELSE
 *                CALL ABLEG4 (ZN, CT, ST, DEFC (1), DEFC (NLEG + 1),
 *         1      DEFC (NLEG * NFOUR + NLEG + 1), Q1, QT1, QZ1, IER, nfour)
 *             END IF
 *
 *        . The following line in file osdate, was changed from:
 *    	TYPE * , 'ERROR IN OSDATE'
 *        to
 *    	PRINT * , 'ERROR IN OSDATE'
 *
 *        . In the file pixlpr.f, all occurrences of the text '0PI12' was changed
 *          to '0P,I12'
 *
 *        . In the file poldsp.f, the following change was made from:
 *          REAL * 4 CS (2)
 *          to:
 *          CHARACTER * 4 CS (2)
 *
 *        . Added the following include line to the rdrasc.f file:
 *          include 'switch.h'    ! switches: lsw0, lsw
 *
 *        . Added the following line to rehead.f:
 *    	      character*4  PID(4)
 *
 *          and changed the following line from:
 *    	      DIMENSION  GX(3), RX(3), PID(4)
 *          to
 *    	      DIMENSION  GX(3), RX(3)
 *
 *        . The following two lines were added to avoid the Fortran
 *          72 character limit in the file vflect.f
 *
 *    	 SG = XV(IN) * XV(iNORM) + YV(IN) * YV(iNORM) +
 *         1        ZV(IN) * ZV(iNORM)
 *
 *    50       WRITE (8, 500) IN, iNORM, KAY, H, XV(iNORM), YV(iNORM),
 *         1                  ZV(iNORM)
 *
 *        . The following substitution was made:
 *    	sed 's/PARAMFILE/integer*4        pf/'
 *          for file parglue.f
 *
 *        . The following lines in the files dedsum.f, delgra.f, fpgrat.f,
 *          fpstat.f, rdasc.f, sctdef.f, ssdef.f, strehl.f, tabgen.f, wrgrid.f
 *          were changed from:
 *
 *          COMMON /PARAMS/ ZLAM, ZK, ZW (21), DP0 (21),
 *         1  DP1S (210), DP1T (210), SFX (21), SFY (21), TFX (21), TFY (21)
 *
 *         to:
 *
 *          COMMON /PARAMS/ ZLAM, ZK, ZW (21), DP0 (21),
 *         1  DP1S (210), DP1T (210), SFX (21), SFY (21), TFX (21), TFY (21),
 *         2  METARR (21)
 *
 *          to be consistent with the definition in fplamp.f
 *
 *        . The file scsum.f was changed to include 'rain.h' instead of using
 *          the errorneous RAIN common block.
 *
 *        . The following line in the file lrgsml.f was changed from:
 *
 *          COMMON /AMNMX/ ARGMAX (2, 5, 21), GRAZMN (21), GRAZMX (21),
 *         1 VZSIMX (5, 21), NCALC (5, 21), NCALC1 (5, 21), NDEFS, NAREAS (21)
 *
 *          to:
 *
 *          COMMON /AMNMX/ ARGMAX (2, 5, 21), GRAZMN (21), GRAZMX (21),
 *         1 VZSIMX (5, 21), NCALC (5, 21), NCALC1 (5, 21), NCALC2 (5, 21),
 *         2 NDEFS, NAREAS (21)
 *
 *        . include 'ident.h was inserted into the following files:
 *          cdfin.f, cnvfil.f, filout.f, headfr.f, hedngs.f, hedray.f,
 *          lkin1.f, ogsum.f, prhdr.f
 *
 *    Revision 2.1  1995/10/07 23:10:50  gaetz
 *    Baseline addition of V7.0 OSAC modifications.
 *
 * Revision 1.1.1.2  1995/01/10  22:35:03  gaetz
 * 1995 January 10 baseline version.
 *
 * See BaselineNote_1995-Jan-10 for details.
 *
 * Revision 1.1.1.1  1993/12/17  02:22:32  gaetz
 * Baseline version, SAO "fullray" binary piped raytrace routines.  Compiles
 * cleanly on Suns (SunOS, SOLARIS) and SGIs (including -mips2 switch).
 *
 * T. J. Gaetz  --  1993 Dec 16
 *
 * Revision 1.1.1.1  1993/12/09  16:50:48  gaetz
 * Initial baseline of 'fullray' version of binary piped SAOsac; compiles
 * cleanly on Sparc (SunOS and Solaris) and SGI (including -mips2).
 *
 * T. Gaetz
 *
 *
 *H*/

typedef struct {
    int      ixray;    /* 1 = x-ray system, 0 = conventional             */
    int      irand;    /* 1 = random rays, 0 = ring&spoke                */
    int      ipolar;   /* 1 = polarized, 0 = not                         */
    int      nran;     /* number of (random) rays                        */
    int      nspokes;  /* number of spokes (const theta)                 */
    int      nrings;   /* number of rings  (const radius)                */
} osacgi;
typedef osacgi *P_OSACGI;

#endif /* OSACGI_H -------------------- END OF FILE -----------------------*/
