#ifndef SUPLIB_PP_IO_H
#define SUPLIB_PP_IO_H

// --8<--8<--8<--8<--
//
// Copyright (C) 2006 Smithsonian Astrophysical Observatory
//
// This file is part of suplibxx
//
// suplibxx is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// suplibxx is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the 
//       Free Software Foundation, Inc. 
//       51 Franklin Street, Fifth Floor
//       Boston, MA  02110-1301, USA
//
// -->8-->8-->8-->8--

#include <fstream>
#include <iostream>
#include <string>

namespace suplib { 

/**
 * \ingroup io
 *
 * \brief Control options for getrecord
 *
 */

enum readopt {

/*!
 * A single physical line makes up a record. A physical line is
 * defined to be all characters up to the delim character.  The delim
 * character is not returned. This ignores any line continuation
 * character.  This is the default.
 *
 */

  READ_PHYS    = 0x00,

/*!
 * A record may span multiple physical lines if the end-of-line
 * delimiter is preceded by the continuation character.  For ease of
 * use, whitespace characters between the continuation character and
 * the delim character are ignored.
 */

  READ_LOGICAL = 0x01,

/*!
 * remove all trailing whitespace from the end of a record.
 *
 */

  STRIP        = 0x02,

/*!
 * on a line with a continuation character, remove any
 * white space following the continuation character, and add
 * a delimiter directly following the continuation character.
 * It has no effect on physical records or the final line in
 * a continued logical record.
 *
 */

  CLEAN        = 0x04,

/*!
 * return the input record (logical or physical) as is,
 * without removing white space.  end of line delimiters will
 * be returned, but because they must be explicitly place din
 * the string (becasue getline() is used to read from the input
 * stream and it silently removes delimiters), there may be
 * an extra delimiter at the end of the record if the input
 * stream ended without a trailing delimiter
 */

  RAW	       = 0x08
};

 std::istream& getrecord(
  std::istream& is,
  std::string& str,
  int opt=READ_PHYS,
  char delim='\n',
  char continuation='\\'
  );


} // ! namespace suplib

#endif // ! SUPLIB_PP_IO_H
