#ifndef CONSTS_H
#define CONSTS_H

/*H**************************************************************************
 *
 * Source     : consts.h
 * Author     : T. Gaetz
 * Version    : 0.0.2
 * Date Begun : 93-___-__ [T. Gaetz]
 * Last Rev   : 93-Nov-22 [T. Gaetz]
 * Id String  : $Id: consts.h,v 1.1 2004/03/16 15:49:47 dtn Exp $
 *
 * Description: mathematical constants
 *
 * Notes      : Source:  AMS 55, Handbook of Mathematical Functions
 *                      Abramowitz and Stegun
 *
 * History:
 *    931122[tjg]: change to #defines with cast to double; reformat
 *                 header comments
 *
 *H*/

/*--- pis ---*/

#define pi       ((double)3.141592653589793238462643)  /*   pi         */
#define pi_2     ((double)6.283185307179586476925287)  /* 2 pi         */
#define pi_4     ((double)12.56637061435917295385057)  /* 4 pi         */

#define pi1_2    ((double)1.570796326794896619231322)  /* pi / 2       */
#define pi1_3    ((double)1.047197551196597746154214)  /* pi / 3       */
#define pi3_2    ((double)4.712388980384689857693965)  /* 3 pi / 2     */
#define pi4_3    ((double)4.188790204786390984616858)  /* 4 pi / 3     */

#define sqrt_pi  ((double)1.772453850905516027298167)  /* sqrt( pi )   */
#define sqrt_2pi ((double)2.506628274631000502415765)  /* sqrt( 2 pi ) */
#define ln_pi    ((double)1.144729885849400174143427)  /* ln( pi )     */
#define log10_pi ((double)4.971498726941338543512683)  /* log_10( pi ) */

/*--- angle conversions ---*/

#define rad2deg    ((double)57.295779513082320876798155) /* rad to degree */
#define deg2rad    ((double)1.7453292519943295769237e-2) /* degree to rad */
#define arcmin2rad ((double)2.90888208665721596154e-4)   /* arcmin to rad */
#define arcsec2rad ((double)4.848136811095359936e-6)     /* arcsec to rad */

#endif /* CONSTS_H ----------------------- END OF FILE --------------------*/
