-- --8<--8<--8<--8<--
--
-- Copyright (C) 2011 Smithsonian Astrophysical Observatory
--
-- This file is part of saotrace.config
--
-- saotrace.config is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or (at
-- your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--
-- -->8-->8-->8-->8--

-- SAOTrace System configuration

local pairs = pairs
local require = require
local pcall = pcall
local error = error
local rawset = rawset
local setmetatable = setmetatable

local table = require( 'table' )

local vi = require( 'validate.inplace' )

local print = print

-- cache this so can keep using it if _M[_M] is deleted in reset() below
local _M = {}


-- return the configuration table for component k
local function index (t, k)

   local ok, config = pcall( require,
			     table.concat( { 'saotrace', k, 'config' }, '.' )
			  )
   if not ok then
      error( "error loading configuration for component saotrace."
	     .. k
	     .. " : "
	     .. config, 2 )
   end

   local ok, validate = pcall( require,
			       table.concat( { 'saotrace', k, 'validate' }, '.' )
			    )
   if not ok then
      error( "error loading validation object for component saotrace."
	     .. k
	     .. " : "
	     .. validate, 2 )
   end

   local vio = vi:new( 'saotrace.config.' .. k,
		       config.specs,
		       validate.vobj )

   rawset( t, k, vio:proxy() )

   return vio:proxy()

end

local function reset( )

   for k in pairs( _M ) do
       _M[k] = nil
   end

end

setmetatable(_M, {
		-- hide this in the metatable to avoid polluting the 
		reset = reset,
		__index = index,
		__newindex = function (t, k, v)
				error( "illegal assignment to saotrace.config." .. k )
			     end,

	     }
	  )


-- clear out what we don't need
reset()

return _M
