#Copy over the contents of the site-packages directory
echo "Copying contrib/lib/python3/site-packages to $SP_DIR"
cp -Rp contrib/lib/python3.*/site-packages/* $SP_DIR
rm -rf contrib/lib/python3.*

#Copying the rest of the contents
cp -Rp contrib/* $PREFIX/

# Copy the [de]activate scripts to $PREFIX/etc/conda/[de]activate.d.
# This will allow them to be run on environment activation.
for CHANGE in "activate" "deactivate"
do
    mkdir -p "${PREFIX}/etc/conda/${CHANGE}.d"
    cp "${RECIPE_DIR}/${CHANGE}.sh" "${PREFIX}/etc/conda/${CHANGE}.d/${PKG_NAME}_${CHANGE}.sh"
    cp "${RECIPE_DIR}/${CHANGE}.csh" "${PREFIX}/etc/conda/${CHANGE}.d/${PKG_NAME}_${CHANGE}.csh"
done

# Create a list of all of the parameter files.
# Used by the post-link.sh and pre-unlink.sh scripts
# to remove and add write permissions respectively.
cd ${PREFIX}/param
find * -maxdepth 0 -type f -name "*.par" -exec echo {} \; > ${PREFIX}/param/.param.ciao-contrib

# Create a list of all of the parameter files.
# Used by the pre-unlink.sh script
# To aid in updating the ahelp index without contrib
cd ${PREFIX}/share/doc/xml
find * -maxdepth 0 -type f -name "*.xml" -exec echo {} \; > ${PREFIX}/share/doc/xml/.xml.ciao-contrib
