# Set some compiler flags
export CFLAGS="-I$PREFIX/include -I$BUILD_PREFIX/include -L$PREFIX/lib -L$BUILD_PREFIX/lib"
export CXXFLAGS="-I$PREFIX/include -I$BUILD_PREFIX/include -L$PREFIX/lib -L$BUILD_PREFIX/lib"
export LDFLAGS="$LDFLAGS -L$PREFIX/lib -L$BUILD_PREFIX/lib"

if [ "$(uname -s)" == "Darwin" ] && [ "$(uname -m)" != "arm64" ] ; then
  CONDA_BUILD_SYSROOT=/opt/MacOSX11.0.sdk
  CONFIG_EXTRA=""
elif [ "$(uname -s)" == "Darwin" ] ; then
  CONDA_BUILD_SYSROOT=/opt/MacOSX11.0.sdk
  CONFIG_EXTRA="--build=arm64-apple-darwin$(uname -r)"
fi

sed -i.orig "s|#define NIOBUF  40|#define NIOBUF  128|g" fitsio2.h

# export MAKE_FLAGS="shared"

./configure --enable-reentrant --enable-static=no --prefix=$PREFIX ${CONFIG_EXTRA}
make $MAKE_FLAGS
make install

cp -p fitsio.h $PREFIX/include
cp -p longnam.h $PREFIX/include
cp -p cfortran.h $PREFIX/include

ls -l $PREFIX/*
