# Set some compiler flags
export CFLAGS="-I$PREFIX/include -I$BUILD_PREFIX/include -L$PREFIX/lib -L$BUILD_PREFIX/lib"
export CXXFLAGS="-I$PREFIX/include -I$BUILD_PREFIX/include -L$PREFIX/lib -L$BUILD_PREFIX/lib"
export LDFLAGS="$LDFLAGS -L$PREFIX/lib -L$BUILD_PREFIX/lib"

if [ "$(uname -s)" == "Darwin" ] && [ "$(uname -m)" != "arm64" ] ; then
  CONDA_BUILD_SYSROOT=/opt/MacOSX11.0.sdk
  CONFIG_EXTRA=""
elif [ "$(uname -s)" == "Darwin" ] ; then
  CONDA_BUILD_SYSROOT=/opt/MacOSX11.0.sdk
  CONFIG_EXTRA="--build=arm64-apple-darwin$(uname -r)"
fi

sed -i.orig "s|#define NIOBUF  40|#define NIOBUF  128|g" fitsio2.h
sed -i.orig "s|cfitsio\.pc|cfitsio-threaded\.pc|g" Makefile.in configure cfitsio.pc.in
rm -f *.orig
mv cfitsio.pc.in cfitsio-threaded.pc.in
./configure --enable-reentrant --enable-shared=no --prefix=$PREFIX ${CONFIG_EXTRA} 2>&1
sed -i.orig "s|= cfitsio|= cfitsio-threaded|g" Makefile
# fix a silly bug caused by the above
sed -i.orig "s|cfitsio-threaded-threaded\.pc|cfitsio-threaded\.pc|g" Makefile

make $MAKE_FLAGS 2>&1
make install 2>&1

#Ensure we ONLY include lib/libcfitsio.a in pkg
rm -f $PREFIX/lib/libcfitsio-threaded.so*
rm -f $PREFIX/lib/pkgconfig/cfitsio.pc
cd $PREFIX/include
rm -f drvrsmem.h fitsio2.h fitsio.h longnam.h cfortran.h f77_wrap.h  region.h
cd $PREFIX/bin
rm -f cookbook  fitscopy  fitsverify  fpack  funpack  imcopy  smem  speed


ls -l $PREFIX
ls -l $PREFIX/*

